/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.util.BladeUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DeployCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUp() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testInstallJar() throws Exception {
        File workspaceDir = this.temporaryFolder.newFolder();
        String[] args = new String[]{"--base", workspaceDir.getPath(), "init", "-v", "7.3"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        args = new String[]{"--base", workspaceDir.getPath(), "server", "init"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        File bundlesDirectory = new File(workspaceDir.getPath(), "bundles");
        Assert.assertTrue((boolean)bundlesDirectory.exists());
        File osgiDirectory = new File(bundlesDirectory, "osgi");
        Assert.assertTrue((boolean)osgiDirectory.exists());
        File osgiModulesDirectory = new File(osgiDirectory, "modules");
        Assert.assertTrue((boolean)osgiModulesDirectory.exists());
        String[] osgiModulesDirectoryList = osgiModulesDirectory.list();
        int filesCount = osgiModulesDirectoryList.length;
        Assert.assertEquals((long)0L, (long)filesCount);
        File modulesDirectory = new File(workspaceDir, "modules");
        Assert.assertTrue((boolean)modulesDirectory.exists());
        args = new String[]{"--base", modulesDirectory.getAbsolutePath(), "create", "-t", "mvc-portlet", "foo"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        File projectDirectory = new File(modulesDirectory, "foo");
        Assert.assertTrue((boolean)projectDirectory.exists());
        args = new String[]{"--base", projectDirectory.getAbsolutePath(), "deploy"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        osgiModulesDirectoryList = osgiModulesDirectory.list();
        filesCount = osgiModulesDirectoryList.length;
        Assert.assertEquals((long)1L, (long)filesCount);
    }

    @Test
    public void testInstallJarStandalone() throws Exception {
        Assume.assumeTrue((!BladeUtil.isWindows() ? 1 : 0) != 0);
        File workspaceDir = this.temporaryFolder.newFolder();
        File standaloneDir = this.temporaryFolder.newFolder();
        String[] args = new String[]{"--base", workspaceDir.getPath(), "init", "-v", "7.3"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        args = new String[]{"--base", workspaceDir.getPath(), "server", "init"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        File bundlesDirectory = new File(workspaceDir.getPath(), "bundles");
        Assert.assertTrue((boolean)bundlesDirectory.exists());
        args = new String[]{"--base", standaloneDir.getAbsolutePath(), "create", "-t", "mvc-portlet", "foo"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File projectDirectory = new File(standaloneDir, "foo");
        Assert.assertTrue((boolean)projectDirectory.exists());
        Path projectDirectoryPath = projectDirectory.toPath();
        File deployDirectory = new File(bundlesDirectory, "deploy");
        String deployDirectoryString = deployDirectory.getAbsolutePath();
        deployDirectoryString = deployDirectoryString.replace("\\", "\\\\");
        String deployDirectoryGradleString = String.format("    deployDir = '%s'", deployDirectoryString);
        List<String> lines = Arrays.asList("", "liferay {", deployDirectoryGradleString, "}");
        Files.write(projectDirectoryPath.resolve("build.gradle"), lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
        args = new String[]{"--base", projectDirectoryPath.toString(), "deploy"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        String[] deployDirectoryList = deployDirectory.list();
        int filesCount = deployDirectoryList.length;
        Assert.assertEquals((long)1L, (long)filesCount);
    }

    @Test
    public void testInstallWar() throws Exception {
        File workspaceDir = this.temporaryFolder.newFolder();
        String[] args = new String[]{"--base", workspaceDir.getPath(), "init", "-v", "7.3"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        args = new String[]{"--base", workspaceDir.getPath(), "server", "init"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        File bundlesDirectory = new File(workspaceDir.getPath(), "bundles");
        Assert.assertTrue((boolean)bundlesDirectory.exists());
        File deployDirectory = new File(bundlesDirectory, "deploy");
        Assert.assertTrue((boolean)deployDirectory.exists());
        String[] deployDirectoryList = deployDirectory.list();
        int filesCount = deployDirectoryList.length;
        Assert.assertEquals((long)0L, (long)filesCount);
        File warsDirectory = new File(workspaceDir, "wars");
        Assert.assertTrue((boolean)warsDirectory.exists());
        args = new String[]{"--base", warsDirectory.getAbsolutePath(), "create", "-t", "war-mvc-portlet", "foo"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        File projectDirectory = new File(warsDirectory, "foo");
        Assert.assertTrue((boolean)projectDirectory.exists());
        args = new String[]{"--base", projectDirectory.getAbsolutePath(), "deploy"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        deployDirectoryList = deployDirectory.list();
        filesCount = deployDirectoryList.length;
        Assert.assertEquals((long)1L, (long)filesCount);
    }
}

