/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.gradle;

import com.liferay.blade.cli.gradle.GradleTooling;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.gradle.tooling.ProjectInfo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GradleToolingTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String _TEST_OUTPUT_PATH = System.getProperty("testOutputPath");
    private static final Path _TOOLING_ZIP = Paths.get(_TEST_OUTPUT_PATH, "tooling.zip");
    private Path _wsPath = null;

    @Before
    public void setUp() throws Exception {
        File wsDir = this.temporaryFolder.newFolder(new String[]{"build", "testws1"});
        this._wsPath = wsDir.toPath();
        Path toolingZipPath = Paths.get("build/tooling.zip", new String[0]);
        Assert.assertTrue((String)"Expected to find tooling.zip", (boolean)Files.exists(toolingZipPath, new LinkOption[0]));
        Files.copy(toolingZipPath, _TOOLING_ZIP, StandardCopyOption.REPLACE_EXISTING);
        FileUtil.copyDir((Path)Paths.get("test-resources/projects/testws1", new String[0]), (Path)this._wsPath);
    }

    @After
    public void tearDownClass() throws Exception {
        Files.delete(_TOOLING_ZIP);
    }

    @Test
    public void testGetOutputFiles() throws Exception {
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo((Path)this._wsPath);
        Map projectOutputFiles = projectInfo.getProjectOutputFiles();
        Assert.assertNotNull((Object)projectOutputFiles);
        Assert.assertEquals((String)projectOutputFiles.toString(), (Object)true, (Object)projectOutputFiles.containsKey(":modules:testportlet"));
        Set files = (Set)projectOutputFiles.get(":modules:testportlet");
        Assert.assertEquals((String)files.toString(), (long)1L, (long)files.size());
    }

    @Test
    public void testGetPluginClassNames() throws Exception {
        Path projectPath = this._wsPath.resolve("modules/testportlet");
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo((Path)projectPath);
        Set pluginClassNames = projectInfo.getPluginClassNames();
        Assert.assertNotNull((Object)pluginClassNames);
        Assert.assertTrue((boolean)pluginClassNames.contains("com.liferay.gradle.plugins.LiferayOSGiPlugin"));
    }

    @Test
    public void testIsLiferayModule() throws Exception {
        Path projectPath = this._wsPath.resolve("modules/testportlet");
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo((Path)projectPath);
        Assert.assertTrue((boolean)projectInfo.isLiferayProject());
    }

    @Test
    public void testIsNotLiferayModule() throws Exception {
        Path projectPath = this._wsPath.resolve("modules");
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo((Path)projectPath);
        Assert.assertFalse((boolean)projectInfo.isLiferayProject());
    }
}

