/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.gradle;

import com.liferay.blade.cli.gradle.GradleWorkspaceProvider;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class WorkspaceProvideGradleTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testIsWorkspace1() throws Exception {
        File workspace = new File(this.temporaryFolder.getRoot(), "workspace");
        workspace.mkdirs();
        File gradleFile = new File(workspace, "settings.gradle");
        String plugin = "apply plugin: \"com.liferay.workspace\"";
        Files.write(gradleFile.toPath(), plugin.getBytes(), new OpenOption[0]);
        GradleWorkspaceProvider workspaceProviderGradle = new GradleWorkspaceProvider();
        Assert.assertTrue((boolean)workspaceProviderGradle.isWorkspace(workspace));
    }

    @Test
    public void testIsWorkspace2() throws Exception {
        File workspace = new File(this.temporaryFolder.getRoot(), "workspace");
        workspace.mkdirs();
        File gradleFile = new File(workspace, "settings.gradle");
        String plugin = "apply plugin: 'com.liferay.workspace'";
        Files.write(gradleFile.toPath(), plugin.getBytes(), new OpenOption[0]);
        GradleWorkspaceProvider workspaceProviderGradle = new GradleWorkspaceProvider();
        Assert.assertTrue((boolean)workspaceProviderGradle.isWorkspace(workspace));
    }

    @Test
    public void testIsWorkspace3() throws Exception {
        File workspace = new File(this.temporaryFolder.getRoot(), "workspace");
        workspace.mkdirs();
        File buildFile = new File(workspace, "build.gradle");
        File settingsFile = new File(workspace, "settings.gradle");
        settingsFile.createNewFile();
        String plugin = "\napply   plugin:   \n\"com.liferay.workspace\"";
        Files.write(buildFile.toPath(), plugin.getBytes(), new OpenOption[0]);
        GradleWorkspaceProvider workspaceProviderGradle = new GradleWorkspaceProvider();
        Assert.assertTrue((boolean)workspaceProviderGradle.isWorkspace(workspace));
    }
}

