/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.util.FileUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ConvertCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUp() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testAll() throws Exception {
        File testdir = new File(this._rootDir, "build/testUpgradePluginsSDKTo70");
        testdir.mkdirs();
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectDir.getPath(), "convert", "-a"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, false, args);
        Assert.assertTrue((boolean)new File(testdir, "plugins-sdk-with-git/modules/sample-service-builder/sample-service-builder-api").exists());
        Assert.assertTrue((boolean)new File(testdir, "plugins-sdk-with-git/modules/sample-service-builder/sample-service-builder-service").exists());
        Assert.assertTrue((boolean)new File(testdir, "plugins-sdk-with-git/wars/sample-service-builder-portlet").exists());
    }

    @Test
    public void testMoveLayouttplToWars() throws Exception {
        File testdir = new File("build/testMoveLayouttplToWars");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectDir.getPath(), "convert", "1-2-1-columns-layouttpl"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File layoutWar = new File(projectDir, "wars/1-2-1-columns-layouttpl");
        Assert.assertTrue((boolean)layoutWar.exists());
        Assert.assertFalse((boolean)new File(layoutWar, "build.xml").exists());
        Assert.assertFalse((boolean)new File(layoutWar, "build.gradle").exists());
        Assert.assertFalse((boolean)new File(layoutWar, "docroot").exists());
    }

    @Test
    public void testMovePluginsToWars() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMovePluginsToWars");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        args = new String[]{"--base", projectDir.getPath(), "convert", "sample-application-adapter-hook"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File sampleExpandoHook = new File(projectDir, "wars/sample-application-adapter-hook");
        Assert.assertTrue((boolean)sampleExpandoHook.exists());
        Assert.assertFalse((boolean)new File(projectDir, "plugins-sdk/hooks/sample-application-adapter-hook").exists());
        args = new String[]{"--base", projectDir.getPath(), "convert", "sample-servlet-filter-hook"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File sampleServletFilterHook = new File(projectDir, "wars/sample-servlet-filter-hook");
        Assert.assertTrue((boolean)sampleServletFilterHook.exists());
        Assert.assertFalse((boolean)new File(projectDir, "plugins-sdk/hooks/sample-servlet-filter-hook").exists());
    }

    @Test
    public void testMoveThemesToWars() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMoveThemesToWar");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File theme = new File(projectDir, "wars/sample-styled-minimal-theme");
        args = new String[]{"--base", projectDir.getPath(), "convert", "-t", "sample-styled-minimal-theme"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Assert.assertTrue((boolean)theme.exists());
        Assert.assertFalse((boolean)new File(theme, "build.xml").exists());
        Assert.assertTrue((boolean)new File(theme, "build.gradle").exists());
        Assert.assertFalse((boolean)new File(theme, "docroot").exists());
        Assert.assertTrue((boolean)new File(theme, "src/main/webapp").exists());
        Assert.assertFalse((boolean)new File(theme, "src/main/webapp/_diffs").exists());
        Assert.assertFalse((boolean)new File(projectDir, "plugins-sdk/themes/sample-styled-minimal-theme").exists());
        args = new String[]{"--base", projectDir.getPath(), "convert", "-t", "sample-styled-advanced-theme"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        File advancedTheme = new File(projectDir, "wars/sample-styled-advanced-theme");
        Assert.assertTrue((boolean)advancedTheme.exists());
        Assert.assertFalse((boolean)new File(advancedTheme, "build.xml").exists());
        Assert.assertTrue((boolean)new File(advancedTheme, "build.gradle").exists());
        Assert.assertFalse((boolean)new File(advancedTheme, "docroot").exists());
        Assert.assertTrue((boolean)new File(advancedTheme, "src/main/webapp").exists());
        Assert.assertFalse((boolean)new File(advancedTheme, "src/main/webapp/_diffs").exists());
        Assert.assertFalse((boolean)new File(projectDir, "plugins-sdk/themes/sample-styled-advanced-theme").exists());
    }

    @Test
    public void testReadIvyXml() throws Exception {
        File projectDir = this._setupWorkspace("readIvyXml");
        String[] args = new String[]{"--base", projectDir.getPath(), "convert", "sample-dao-portlet"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        this._contains(new File(projectDir, "wars/sample-dao-portlet/build.gradle"), ".*compile group: 'c3p0', name: 'c3p0', version: '0.9.0.4'.*", ".*compile group: 'mysql', name: 'mysql-connector-java', version: '5.0.7'.*");
        args = new String[]{"--base", projectDir.getPath(), "convert", "sample-tapestry-portlet"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        this._contains(new File(projectDir, "wars/sample-tapestry-portlet/build.gradle"), ".*compile group: 'hivemind', name: 'hivemind', version: '1.1'.*", ".*compile group: 'hivemind', name: 'hivemind-lib', version: '1.1'.*", ".*compile group: 'org.apache.tapestry', name: 'tapestry-annotations', version: '4.1'.*", ".*compile group: 'org.apache.tapestry', name: 'tapestry-framework', version: '4.1'.*", ".*compile group: 'org.apache.tapestry', name: 'tapestry-portlet', version: '4.1'.*");
        Assert.assertFalse((boolean)new File(projectDir, "wars/sample-tapestry-portlet/ivy.xml").exists());
    }

    @Test
    public void testThemeDocrootBackup() throws Exception {
        File projectDir = this._setupWorkspace("testThemeDocrootBackup");
        String[] args = new String[]{"--base", projectDir.getPath(), "convert", "-t", "sample-html4-theme"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Assert.assertTrue((boolean)new File(projectDir, "wars/sample-html4-theme/docroot_backup/other/afile").exists());
    }

    private void _contains(File file, String ... patterns) throws Exception {
        String content = FileUtil.read((File)file);
        for (String pattern : patterns) {
            this._contains(content, pattern);
        }
    }

    private void _contains(String content, String regex) throws Exception {
        Pattern pattern = Pattern.compile(regex, 40);
        Assert.assertTrue((boolean)pattern.matcher(content).matches());
    }

    private File _setupWorkspace(String name) throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/" + name);
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u"};
        TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        Assert.assertTrue((boolean)pluginsSdkDir.exists());
        return projectDir;
    }
}

