/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.gradle;

import com.liferay.blade.cli.gradle.GradleTooling;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.gradle.tooling.ProjectInfo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GradleToolingTest {
    @ClassRule
    public static final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String _TEST_OUTPUT_PATH = System.getProperty("testOutputPath");
    private static final File _TOOLING_ZIP = new File(_TEST_OUTPUT_PATH + "/tooling.zip");

    @BeforeClass
    public static void setUpClass() throws Exception {
        File wsDir = temporaryFolder.newFolder(new String[]{"build", "testws1"});
        Path toolingZipPath = Paths.get("build/tooling.zip", new String[0]);
        Assert.assertTrue((boolean)Files.exists(toolingZipPath, new LinkOption[0]));
        Files.copy(toolingZipPath, _TOOLING_ZIP.toPath(), StandardCopyOption.REPLACE_EXISTING);
        FileUtil.copyDir((Path)Paths.get("test-resources/projects/testws1", new String[0]), (Path)wsDir.toPath());
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Files.delete(_TOOLING_ZIP.toPath());
    }

    @Test
    public void testGetOutputFiles() throws Exception {
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo((Path)new File(temporaryFolder.getRoot(), "build/testws1").toPath());
        Map projectOutputFiles = projectInfo.getProjectOutputFiles();
        Assert.assertNotNull((Object)projectOutputFiles);
        Assert.assertEquals((String)projectOutputFiles.toString(), (Object)true, (Object)projectOutputFiles.containsKey(":modules:testportlet"));
        Set files = (Set)projectOutputFiles.get(":modules:testportlet");
        Assert.assertEquals((String)files.toString(), (long)1L, (long)files.size());
    }

    @Test
    public void testGetPluginClassNames() throws Exception {
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo((Path)new File(temporaryFolder.getRoot(), "build/testws1/modules/testportlet").toPath());
        Set pluginClassNames = projectInfo.getPluginClassNames();
        Assert.assertNotNull((Object)pluginClassNames);
        Assert.assertTrue((boolean)pluginClassNames.contains("com.liferay.gradle.plugins.LiferayOSGiPlugin"));
    }

    @Test
    public void testIsLiferayModule() throws Exception {
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo((Path)new File(temporaryFolder.getRoot(), "build/testws1/modules/testportlet").toPath());
        Assert.assertTrue((boolean)projectInfo.isLiferayProject());
    }

    @Test
    public void testIsNotLiferayModule() throws Exception {
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo((Path)new File(temporaryFolder.getRoot(), "build/testws1/modules").toPath());
        Assert.assertFalse((boolean)projectInfo.isLiferayProject());
    }
}

