/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.GradleRunnerUtil;
import com.liferay.blade.cli.StringPrintStream;
import com.liferay.blade.cli.XMLTestUtil;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gradle.testkit.runner.BuildTask;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TestUtil {
    private static final String _REPOSITORY_CDN_URL = "https://repository-cdn.liferay.com/nexus/content/groups/public";

    public static BladeTestResults runBlade(BladeTest bladeTest, PrintStream outputStream, PrintStream errorStream, boolean assertErrors, String ... args) throws Exception {
        try {
            bladeTest.run(args);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String error = errorStream.toString();
        try (Scanner scanner = new Scanner(error);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line == null || line.length() <= 0 || line.startsWith("SLF4J:") || line.contains("LC_ALL: cannot change locale") || !assertErrors) continue;
                Assert.fail((String)("Encountered error at line: " + line + "\n" + error));
            }
        }
        String content = outputStream.toString();
        return new BladeTestResults(bladeTest, content, error);
    }

    public static BladeTestResults runBlade(BladeTest bladeTest, PrintStream outputStream, PrintStream errorStream, String ... args) throws Exception {
        return TestUtil.runBlade(bladeTest, outputStream, errorStream, true, args);
    }

    public static BladeTestResults runBlade(boolean assertErrors, String ... args) throws Exception {
        return TestUtil.runBlade(new File(System.getProperty("user.home")), new File(System.getProperty("user.home")), System.in, assertErrors, args);
    }

    public static BladeTestResults runBlade(File settingsDir, File extensionsDir, boolean assertErrors, String ... args) throws Exception {
        return TestUtil.runBlade(settingsDir, extensionsDir, System.in, assertErrors, args);
    }

    public static BladeTestResults runBlade(File settingsDir, File extensionsDir, InputStream in, boolean assertErrors, String ... args) throws Exception {
        StringPrintStream outputPrintStream = StringPrintStream.newInstance();
        StringPrintStream errorPrintStream = StringPrintStream.newInstance();
        return TestUtil.runBlade(settingsDir, extensionsDir, (PrintStream)outputPrintStream, (PrintStream)errorPrintStream, in, assertErrors, args);
    }

    public static BladeTestResults runBlade(File settingsDir, File extensionsDir, InputStream in, String ... args) throws Exception {
        return TestUtil.runBlade(settingsDir, extensionsDir, in, true, args);
    }

    public static BladeTestResults runBlade(File settingsDir, File extensionsDir, PrintStream out, PrintStream err, InputStream in, boolean assertErrors, String ... args) throws Exception {
        BladeTest.BladeTestBuilder bladeTestBuilder = BladeTest.builder();
        bladeTestBuilder.setExtensionsDir(extensionsDir.toPath());
        String settingsDirName = settingsDir.getName();
        if (!".blade".equals(settingsDirName)) {
            settingsDir = new File(settingsDir, ".blade");
        }
        bladeTestBuilder.setAssertErrors(assertErrors);
        bladeTestBuilder.setSettingsDir(settingsDir.toPath());
        bladeTestBuilder.setStdError(err);
        bladeTestBuilder.setStdIn(in);
        bladeTestBuilder.setStdOut(out);
        BladeTest bladeTest = bladeTestBuilder.build();
        return TestUtil.runBlade(bladeTest, out, err, assertErrors, args);
    }

    public static BladeTestResults runBlade(File settingsDir, File extensionsDir, String ... args) throws Exception {
        return TestUtil.runBlade(settingsDir, extensionsDir, System.in, true, args);
    }

    public static BladeTestResults runBlade(String ... args) throws Exception {
        return TestUtil.runBlade(new File(System.getProperty("user.home")), new File(System.getProperty("user.home")), System.in, true, args);
    }

    public static void updateMavenRepositories(String projectPath) throws Exception {
        File pomXmlFile = new File(projectPath + "/pom.xml");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(pomXmlFile);
        TestUtil._addNexusRepositoriesElement(document, "repositories", "repository");
        TestUtil._addNexusRepositoriesElement(document, "pluginRepositories", "pluginRepository");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource domSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(pomXmlFile);
        transformer.transform(domSource, streamResult);
    }

    public static void verifyBuild(String projectPath, String outputFileName) throws Exception {
        TestUtil.verifyBuild(projectPath, "build", outputFileName);
    }

    public static void verifyBuild(String projectPath, String taskPath, String outputFileName) throws Exception {
        Path settingsGradlePath;
        Path path = Paths.get(projectPath, new String[0]);
        Path buildGradlePath = path.resolve("build.gradle");
        String content = "\nbuildscript { repositories { mavenLocal() } }";
        if (Files.exists(buildGradlePath, new LinkOption[0])) {
            Files.write(buildGradlePath, content.getBytes(), StandardOpenOption.APPEND);
        }
        if (Files.exists(settingsGradlePath = path.resolve("settings.gradle"), new LinkOption[0])) {
            Files.write(settingsGradlePath, content.getBytes(), StandardOpenOption.APPEND);
        }
        BuildTask buildTask = GradleRunnerUtil.executeGradleRunner(projectPath, taskPath);
        GradleRunnerUtil.verifyGradleRunnerOutput(buildTask);
        GradleRunnerUtil.verifyBuildOutput(projectPath, outputFileName);
    }

    private static void _addNexusRepositoriesElement(Document document, String parentElementName, String elementName) {
        Element projectElement = document.getDocumentElement();
        Element repositoriesElement = XMLTestUtil.getChildElement(projectElement, parentElementName);
        if (repositoriesElement == null) {
            repositoriesElement = document.createElement(parentElementName);
            projectElement.appendChild(repositoriesElement);
        }
        Element repositoryElement = document.createElement(elementName);
        Element idElement = document.createElement("id");
        idElement.appendChild(document.createTextNode(System.currentTimeMillis() + ""));
        Element urlElement = document.createElement("url");
        Text urlText = document.createTextNode(_REPOSITORY_CDN_URL);
        urlElement.appendChild(urlText);
        repositoryElement.appendChild(idElement);
        repositoryElement.appendChild(urlElement);
        repositoriesElement.appendChild(repositoryElement);
    }
}

