/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.util.Prompter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class PrompterTest {
    private String _question = "Hello world?";

    @Test
    public void testConfirmDefaultQuestions() throws Exception {
        HashMap<String, Boolean> correctAnswerDefaultTrueTests = new HashMap<String, Boolean>();
        correctAnswerDefaultTrueTests.put("foobar", true);
        correctAnswerDefaultTrueTests.put("n", false);
        correctAnswerDefaultTrueTests.put("n ", false);
        correctAnswerDefaultTrueTests.put("y", true);
        correctAnswerDefaultTrueTests.put("y ", true);
        HashMap<String, Boolean> correctAnswerDefaultFalseTests = new HashMap<String, Boolean>();
        correctAnswerDefaultFalseTests.put("foobar", false);
        correctAnswerDefaultFalseTests.put("n", false);
        correctAnswerDefaultFalseTests.put("n ", false);
        correctAnswerDefaultFalseTests.put("y", true);
        correctAnswerDefaultFalseTests.put("y ", true);
        Optional<Boolean> trueDefaultAnswer = Optional.of(true);
        this._testAnswers(correctAnswerDefaultTrueTests, trueDefaultAnswer);
        Optional<Boolean> falseDefaultAnswer = Optional.of(false);
        this._testAnswers(correctAnswerDefaultFalseTests, falseDefaultAnswer);
    }

    @Test
    public void testConfirmQuestions() throws Exception {
        HashMap<String, Boolean> correctAnswerTests = new HashMap<String, Boolean>();
        correctAnswerTests.put(" n ", false);
        correctAnswerTests.put(" y ", true);
        correctAnswerTests.put("n", false);
        correctAnswerTests.put("N", false);
        correctAnswerTests.put("no", false);
        correctAnswerTests.put("No", false);
        correctAnswerTests.put("nO", false);
        correctAnswerTests.put("NO", false);
        correctAnswerTests.put("y", true);
        correctAnswerTests.put("Y", true);
        correctAnswerTests.put("yes", true);
        correctAnswerTests.put("YES", true);
        correctAnswerTests.put("yEs", true);
        correctAnswerTests.put("YeS", true);
        this._testAnswers(correctAnswerTests);
    }

    @Test
    public void testConfirmQuestionsOutput() throws Exception {
        String answer = "y";
        String correctResult = this._question + " (y/n)";
        String output = PrompterTest._confirm(this._question, answer).getValue();
        Assert.assertEquals((Object)output.trim(), (Object)correctResult);
        HashMap correctEndingOutputTests = new HashMap();
        correctEndingOutputTests.put("(Y/n)", Optional.of(true));
        correctEndingOutputTests.put("(y/N)", Optional.of(false));
        correctEndingOutputTests.put("(y/n)", Optional.empty());
        for (Map.Entry entry : correctEndingOutputTests.entrySet()) {
            String receivedOutput = PrompterTest._confirm(this._question, answer, (Optional)entry.getValue()).getValue();
            receivedOutput = receivedOutput.trim();
            correctResult = this._question + " " + (String)entry.getKey();
            boolean assertBoolean = Objects.equals(receivedOutput, correctResult);
            Assert.assertTrue((boolean)assertBoolean);
        }
    }

    private static Map.Entry<Boolean, String> _confirm(String question, String answerString) throws UnsupportedEncodingException {
        return PrompterTest._confirm(question, answerString, Optional.empty());
    }

    private static Map.Entry<Boolean, String> _confirm(String question, String answerString, Optional<Boolean> defaultAnswer) throws UnsupportedEncodingException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        ByteArrayInputStream in = new ByteArrayInputStream(answerString.getBytes("UTF-8"));
        boolean answer = Prompter.confirm((String)question, (InputStream)in, (PrintStream)out, defaultAnswer);
        String outString = outStream.toString();
        return new AbstractMap.SimpleEntry<Boolean, String>(answer, outString);
    }

    private void _testAnswer(String answerString, Boolean correctAnswerValue, Optional<Boolean> defaultAnswer) throws UnsupportedEncodingException {
        Boolean receivedAnswer = PrompterTest._confirm(this._question, answerString, defaultAnswer).getKey();
        boolean assertBoolean = Objects.equals(receivedAnswer, correctAnswerValue);
        Assert.assertTrue((boolean)assertBoolean);
    }

    private void _testAnswers(Map<String, Boolean> correctAnswerTestMap) throws UnsupportedEncodingException {
        this._testAnswers(correctAnswerTestMap, Optional.empty());
    }

    private void _testAnswers(Map<String, Boolean> correctAnswerTestMap, Optional<Boolean> defaultAnswer) throws UnsupportedEncodingException {
        for (Map.Entry<String, Boolean> entry : correctAnswerTestMap.entrySet()) {
            String answerString = entry.getKey();
            Boolean correctAnswerValue = entry.getValue();
            this._testAnswer(answerString, correctAnswerValue, defaultAnswer);
        }
    }
}

