/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeSettings;
import com.liferay.blade.cli.StringPrintStream;
import com.liferay.blade.cli.util.WorkspaceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class BladeTest
extends BladeCLI {
    private boolean _assertErrors = true;
    private Path _extensionsDir;
    private Path _settingsDir;

    public static BladeTestBuilder builder() {
        return new BladeTestBuilder();
    }

    public BladeSettings getBladeSettings() throws IOException {
        File settingsFile;
        if (WorkspaceUtil.isWorkspace((BladeCLI)this)) {
            File workspaceDir = WorkspaceUtil.getWorkspaceDir((BladeCLI)this);
            settingsFile = new File(workspaceDir, ".blade/settings.properties");
        } else {
            Path settingsPath = this._settingsDir.resolve("settings.properties");
            settingsFile = settingsPath.toFile();
        }
        return new BladeSettings(settingsFile);
    }

    public Path getExtensionsPath() {
        try {
            Files.createDirectories(this._extensionsDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._extensionsDir;
    }

    public void postRunCommand() {
    }

    public void run(String[] args) throws Exception {
        PrintStream error;
        super.run(args);
        if (this._assertErrors && (error = this.error()) instanceof StringPrintStream) {
            StringPrintStream stringPrintStream = (StringPrintStream)error;
            String errors = stringPrintStream.get();
            errors = errors.replaceAll("sh: warning: setlocale: LC_ALL: cannot change locale \\(en_US.UTF-8\\)", "");
            errors = errors.trim();
            if (!(errors = errors.replaceAll("^\\/bin\\/$", "")).isEmpty()) {
                throw new Exception("Errors not empty:\n" + errors);
            }
        }
    }

    protected BladeTest(PrintStream out, PrintStream err, InputStream in) {
        super(out, err, in);
    }

    public static class BladeTestBuilder {
        private boolean _assertErrors = true;
        private Path _extensionsDir = null;
        private Path _settingsDir = null;
        private PrintStream _stdError = null;
        private InputStream _stdIn = null;
        private PrintStream _stdOut = null;
        private Path _userHomePath = Paths.get(System.getProperty("user.home"), new String[0]);

        public BladeTest build() {
            if (this._extensionsDir == null) {
                this._extensionsDir = this._userHomePath.resolve(".blade/extensions");
            }
            if (this._settingsDir == null) {
                this._settingsDir = this._userHomePath.resolve(".blade");
            }
            if (this._stdIn == null) {
                this._stdIn = System.in;
            }
            if (this._stdOut == null) {
                this._stdOut = StringPrintStream.newInstance();
            }
            if (this._stdError == null) {
                this._stdError = StringPrintStream.newInstance();
            }
            BladeTest bladeTest = new BladeTest(this._stdOut, this._stdError, this._stdIn);
            bladeTest._assertErrors = this._assertErrors;
            bladeTest._extensionsDir = this._extensionsDir;
            bladeTest._settingsDir = this._settingsDir;
            return bladeTest;
        }

        public void setAssertErrors(boolean assertErrors) {
            this._assertErrors = assertErrors;
        }

        public void setExtensionsDir(Path extensionsDir) {
            this._extensionsDir = extensionsDir;
        }

        public void setSettingsDir(Path settingsDir) {
            this._settingsDir = settingsDir;
        }

        public void setStdError(PrintStream printStream) {
            this._stdError = printStream;
        }

        public void setStdIn(InputStream inputStream) {
            this._stdIn = inputStream;
        }

        public void setStdOut(PrintStream printStream) {
            this._stdOut = printStream;
        }
    }
}

