/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.TestUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DeployCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testInstallJar() throws Exception {
        File workspaceDir = this.temporaryFolder.newFolder();
        String[] args = new String[]{"--base", workspaceDir.getPath(), "init", "-f"};
        TestUtil.runBlade(workspaceDir, args);
        args = new String[]{"--base", workspaceDir.getPath(), "server", "init"};
        TestUtil.runBlade(workspaceDir, args);
        File bundlesDirectory = new File(workspaceDir.getPath(), "bundles");
        Assert.assertTrue((boolean)bundlesDirectory.exists());
        File osgiDirectory = new File(bundlesDirectory, "osgi");
        Assert.assertTrue((boolean)osgiDirectory.exists());
        File osgiModulesDirectory = new File(osgiDirectory, "modules");
        Assert.assertTrue((boolean)osgiModulesDirectory.exists());
        int filesCount = osgiModulesDirectory.list().length;
        Assert.assertEquals((long)0L, (long)filesCount);
        File modulesDirectory = new File(workspaceDir, "modules");
        Assert.assertTrue((boolean)modulesDirectory.exists());
        args = new String[]{"--base", modulesDirectory.getAbsolutePath(), "create", "-t", "soy-portlet", "foo"};
        TestUtil.runBlade(workspaceDir, args);
        File projectDirectory = new File(modulesDirectory, "foo");
        Assert.assertTrue((boolean)projectDirectory.exists());
        args = new String[]{"--base", projectDirectory.getAbsolutePath(), "deploy"};
        TestUtil.runBlade(workspaceDir, args);
        filesCount = osgiModulesDirectory.list().length;
        Assert.assertEquals((long)1L, (long)filesCount);
    }

    @Test
    public void testInstallJarStandalone() throws Exception {
        File workspaceDir = this.temporaryFolder.newFolder();
        File standaloneDir = this.temporaryFolder.newFolder();
        String[] args = new String[]{"--base", workspaceDir.getPath(), "init", "-f"};
        TestUtil.runBlade(workspaceDir, args);
        args = new String[]{"--base", workspaceDir.getPath(), "server", "init"};
        TestUtil.runBlade(workspaceDir, args);
        File bundlesDirectory = new File(workspaceDir.getPath(), "bundles");
        Assert.assertTrue((boolean)bundlesDirectory.exists());
        args = new String[]{"--base", standaloneDir.getAbsolutePath(), "create", "-t", "soy-portlet", "foo"};
        TestUtil.runBlade(standaloneDir, args);
        File projectDirectory = new File(standaloneDir, "foo");
        Assert.assertTrue((boolean)projectDirectory.exists());
        Path projectDirectoryPath = projectDirectory.toPath();
        File deployDirectory = new File(bundlesDirectory, "deploy");
        String deployDirectoryString = deployDirectory.getAbsolutePath();
        deployDirectoryString = deployDirectoryString.replace("\\", "\\\\");
        String deployDirectoryGradleString = String.format("    deployDir = '%s'", deployDirectoryString);
        List<String> lines = Arrays.asList("", "liferay {", deployDirectoryGradleString, "}");
        Files.write(projectDirectoryPath.resolve("build.gradle"), lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
        args = new String[]{"--base", projectDirectoryPath.toString(), "deploy"};
        TestUtil.runBlade(standaloneDir, args);
        int filesCount = deployDirectory.list().length;
        Assert.assertEquals((long)1L, (long)filesCount);
    }

    @Test
    public void testInstallWar() throws Exception {
        File workspaceDir = this.temporaryFolder.newFolder();
        String[] args = new String[]{"--base", workspaceDir.getPath(), "init", "-f"};
        TestUtil.runBlade(workspaceDir, args);
        args = new String[]{"--base", workspaceDir.getPath(), "server", "init"};
        TestUtil.runBlade(workspaceDir, args);
        File bundlesDirectory = new File(workspaceDir.getPath(), "bundles");
        Assert.assertTrue((boolean)bundlesDirectory.exists());
        File deployDirectory = new File(bundlesDirectory, "deploy");
        Assert.assertTrue((boolean)deployDirectory.exists());
        int filesCount = deployDirectory.list().length;
        Assert.assertEquals((long)0L, (long)filesCount);
        File warsDirectory = new File(workspaceDir, "wars");
        Assert.assertTrue((boolean)warsDirectory.exists());
        args = new String[]{"--base", warsDirectory.getAbsolutePath(), "create", "-t", "war-mvc-portlet", "foo"};
        TestUtil.runBlade(workspaceDir, args);
        File projectDirectory = new File(warsDirectory, "foo");
        Assert.assertTrue((boolean)projectDirectory.exists());
        args = new String[]{"--base", projectDirectory.getAbsolutePath(), "deploy"};
        TestUtil.runBlade(workspaceDir, args);
        filesCount = deployDirectory.list().length;
        Assert.assertEquals((long)1L, (long)filesCount);
    }
}

