/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.WorkspaceUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UtilTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testAppServerProperties() throws Exception {
        File dir = this.temporaryFolder.getRoot();
        File appServerProperty1 = new File(dir, "app.server." + System.getProperty("user.name") + ".properties");
        appServerProperty1.createNewFile();
        File appServerProperty2 = new File(dir, "app.server.properties");
        appServerProperty2.createNewFile();
        List propertiesList = BladeUtil.getAppServerProperties((File)dir);
        Assert.assertTrue((propertiesList.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testCopyEntireDirectory() throws Exception {
        File testDir1 = this.temporaryFolder.newFolder("dir1");
        File testFile1 = new File(testDir1, "1");
        File testFile2 = new File(testDir1, "2");
        File testFile3 = new File(testDir1, "3");
        testFile1.createNewFile();
        testFile2.createNewFile();
        testFile3.createNewFile();
        File testDir2 = new File(this.temporaryFolder.getRoot(), "dir2");
        FileUtil.copyDir((Path)testDir1.toPath(), (Path)testDir2.toPath());
        Assert.assertTrue((boolean)testDir2.exists());
        Assert.assertEquals((long)testDir1.list().length, (long)testDir2.list().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindParentFile() throws Exception {
        File tempTestFile = null;
        try {
            File parentDirectory = new File(".").getAbsoluteFile().getParentFile();
            File parentParentDirectory = parentDirectory.getParentFile();
            tempTestFile = new File(parentParentDirectory, "test.file");
            if (tempTestFile.exists()) {
                Assert.assertTrue((boolean)tempTestFile.delete());
            }
            Assert.assertTrue((boolean)tempTestFile.createNewFile());
            File fileRelative = new File(".");
            File foundFile = BladeUtil.findParentFile((File)fileRelative, (String[])new String[]{"test.file"}, (boolean)true);
            Assert.assertTrue((boolean)Objects.nonNull(foundFile));
        }
        finally {
            if (tempTestFile != null) {
                Files.delete(tempTestFile.toPath());
            }
        }
    }

    @Test
    public void testIsWorkspace1() throws Exception {
        File workspace = new File(this.temporaryFolder.getRoot(), "workspace");
        workspace.mkdirs();
        File gradleFile = new File(workspace, "settings.gradle");
        String plugin = "apply plugin: \"com.liferay.workspace\"";
        Files.write(gradleFile.toPath(), plugin.getBytes(), new OpenOption[0]);
        Assert.assertTrue((boolean)WorkspaceUtil.isWorkspace((File)workspace));
    }

    @Test
    public void testIsWorkspace2() throws Exception {
        File workspace = new File(this.temporaryFolder.getRoot(), "workspace");
        workspace.mkdirs();
        File gradleFile = new File(workspace, "settings.gradle");
        String plugin = "apply plugin: 'com.liferay.workspace'";
        Files.write(gradleFile.toPath(), plugin.getBytes(), new OpenOption[0]);
        Assert.assertTrue((boolean)WorkspaceUtil.isWorkspace((File)workspace));
    }

    @Test
    public void testIsWorkspace3() throws Exception {
        File workspace = new File(this.temporaryFolder.getRoot(), "workspace");
        workspace.mkdirs();
        File buildFile = new File(workspace, "build.gradle");
        File settingsFile = new File(workspace, "settings.gradle");
        settingsFile.createNewFile();
        String plugin = "\napply   plugin:   \n\"com.liferay.workspace\"";
        Files.write(buildFile.toPath(), plugin.getBytes(), new OpenOption[0]);
        Assert.assertTrue((boolean)WorkspaceUtil.isWorkspace((File)workspace));
    }
}

