/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.BladeSettings;
import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.Extensions;
import com.liferay.blade.cli.TestUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ExtensionsTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final int _BUILT_IN_COMMANDS_COUNT = ExtensionsTest._getBuiltInCommandsCount();
    private BladeTest _bladeTest;

    @Before
    public void setUp() throws Exception {
        this._bladeTest = new BladeTest(this.temporaryFolder.getRoot());
    }

    @Test
    public void testArgsSort() throws Exception {
        Map commands;
        String[] args = new String[]{"--base", "/foo/bar/dir/", "--flag1", "extension", "install", "/path/to/jar.jar", "--flag2"};
        try (Extensions extensions = new Extensions(this._bladeTest.getBladeSettings(), this._bladeTest.getExtensionsPath());){
            commands = extensions.getCommands();
        }
        String[] sortedArgs = Extensions.sortArgs((Map)commands, (String[])args);
        boolean correctSort = false;
        for (String arg : sortedArgs) {
            if (!Objects.equals(arg, "extension install")) continue;
            correctSort = true;
        }
        Assert.assertTrue((boolean)correctSort);
    }

    @Test
    public void testLoadCommandsBuiltIn() throws Exception {
        try (Extensions extensions = new Extensions(this._bladeTest.getBladeSettings(), this._bladeTest.getExtensionsPath());){
            Map commands = extensions.getCommands();
            Assert.assertNotNull((Object)commands);
            Assert.assertEquals((String)commands.toString(), (long)_BUILT_IN_COMMANDS_COUNT, (long)commands.size());
        }
    }

    @Test
    public void testLoadCommandsWithCustomExtension() throws Exception {
        this._setupTestExtensions();
        BladeTest bladeTest = new BladeTest(this.temporaryFolder.getRoot());
        try (Extensions extensions = new Extensions(bladeTest.getBladeSettings(), bladeTest.getExtensionsPath());){
            Map commands = extensions.getCommands();
            Assert.assertNotNull((Object)commands);
            Assert.assertEquals((String)commands.toString(), (long)(_BUILT_IN_COMMANDS_COUNT + 1), (long)commands.size());
        }
    }

    @Test
    public void testLoadCommandsWithCustomExtensionInWorkspace() throws Exception {
        this._setupTestExtensions();
        File workspaceDir = this.temporaryFolder.newFolder(new String[]{"build", "test", "workspace"});
        String[] args = new String[]{"--base", workspaceDir.getPath(), "init", "-P", "foo"};
        TestUtil.runBlade(this.temporaryFolder.getRoot(), args);
        BladeTest bladeTest = new BladeTest(this.temporaryFolder.getRoot());
        BladeSettings settings = bladeTest.getBladeSettings();
        settings.setProfileName("foo");
        try (Extensions extensions = new Extensions(settings, bladeTest.getExtensionsPath());){
            Map commands = extensions.getCommands();
            Assert.assertNotNull((Object)commands);
            Assert.assertEquals((String)commands.toString(), (long)(_BUILT_IN_COMMANDS_COUNT + 2), (long)commands.size());
        }
    }

    private static int _getBuiltInCommandsCount() {
        ClassLoader classLoader = ExtensionsTest.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/services/com.liferay.blade.cli.command.BaseCommand");
        try (Scanner scanner = new Scanner(inputStream);){
            int numLines = 0;
            while (scanner.hasNextLine()) {
                scanner.nextLine();
                ++numLines;
            }
            int n = numLines;
            return n;
        }
    }

    private static void _setupTestExtension(Path extensionsPath, String jarPath) throws IOException {
        File sampleJarFile = new File(jarPath);
        Assert.assertTrue((String)(sampleJarFile.getAbsolutePath() + " does not exist."), (boolean)sampleJarFile.exists());
        Path sampleJarPath = extensionsPath.resolve(sampleJarFile.getName());
        Files.copy(sampleJarFile.toPath(), sampleJarPath, StandardCopyOption.REPLACE_EXISTING);
        Assert.assertTrue((boolean)Files.exists(sampleJarPath, new LinkOption[0]));
    }

    private void _setupTestExtensions() throws Exception {
        File extensionsDir = new File(this.temporaryFolder.getRoot(), ".blade/extensions");
        extensionsDir.mkdirs();
        Assert.assertTrue((String)"Unable to create test extensions dir.", (boolean)extensionsDir.exists());
        Path extensionsPath = extensionsDir.toPath();
        ExtensionsTest._setupTestExtension(extensionsPath, System.getProperty("sampleCommandJarFile"));
        ExtensionsTest._setupTestExtension(extensionsPath, System.getProperty("sampleProfileJarFile"));
        ExtensionsTest._setupTestExtension(extensionsPath, System.getProperty("sampleTemplateJarFile"));
    }
}

