/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.command.JavaProcess;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class JavaProcesses {
    public static Collection<JavaProcess> list() {
        return JavaProcesses.list(Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<JavaProcess> list(Optional<Consumer<String>> logger) {
        HashSet<JavaProcess> javaProcesses = new HashSet<JavaProcess>();
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        ClassLoader toolsClassloader = null;
        try {
            toolsClassloader = JavaProcesses._getToolsClassLoader(cl);
            if (toolsClassloader != null) {
                thread.setContextClassLoader(toolsClassloader);
                JavaProcesses._log(logger, "Trying to load VirtualMachine class...");
                Class<?> vmClass = toolsClassloader.loadClass("com.sun.tools.attach.VirtualMachine");
                Method listMethod = vmClass.getMethod("list", new Class[0]);
                List vmds = (List)listMethod.invoke(null, new Object[0]);
                JavaProcesses._log(logger, "Found " + vmds.size() + " vms on this machine.");
                for (Object vmd : vmds) {
                    Class<?> vmdClass = toolsClassloader.loadClass("com.sun.tools.attach.VirtualMachineDescriptor");
                    Method displayNameMethod = vmdClass.getMethod("displayName", new Class[0]);
                    String displayName = (String)displayNameMethod.invoke(vmd, new Object[0]);
                    Method idMethod = vmdClass.getMethod("id", new Class[0]);
                    String id = (String)idMethod.invoke(vmd, new Object[0]);
                    JavaProcesses._log(logger, "Found vm id of " + id + " with name " + displayName + ". Trying to attach...");
                    javaProcesses.add(new JavaProcess(Integer.parseInt(id), displayName));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            thread.setContextClassLoader(cl);
            try {
                if (toolsClassloader != null) {
                    Field nl = ClassLoader.class.getDeclaredField("nativeLibraries");
                    nl.setAccessible(true);
                    Vector nativeLibs = (Vector)nl.get(toolsClassloader);
                    for (Object nativeLib : nativeLibs) {
                        Class<?> clazz = nativeLib.getClass();
                        Field nameField = clazz.getDeclaredField("name");
                        nameField.setAccessible(true);
                        String name = (String)nameField.get(nativeLib);
                        File nativeLibFile = new File(name);
                        String nativeLibFileName = nativeLibFile.getName();
                        if (!nativeLibFileName.contains("attach")) continue;
                        Method f = clazz.getDeclaredMethod("finalize", new Class[0]);
                        f.setAccessible(true);
                        f.invoke(nativeLib, new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return javaProcesses;
    }

    public static void main(String[] args) {
        Collection<JavaProcess> processes = JavaProcesses.list(Optional.of(msg -> System.out.println((String)msg)));
        Predicate<JavaProcess> tomcatFilter = process -> {
            String displayName = process.getDisplayName();
            return displayName.contains("org.apache.catalina.startup.Bootstrap");
        };
        Stream<JavaProcess> stream = processes.stream();
        Optional<JavaProcess> tomcatProcess = stream.filter(tomcatFilter).findAny();
        System.out.println("tomcatProcess = " + tomcatProcess.get().getId());
    }

    private static File _findJdkJar(String jar) throws IOException {
        File retval = null;
        String jarPath = File.separator + "lib" + File.separator + jar;
        String javaHome = System.getProperty("java.home");
        File jarFile = new File(javaHome + jarPath);
        if (jarFile.exists()) {
            retval = jarFile;
        } else {
            jarFile = new File(javaHome + "/.." + jarPath);
            if (jarFile.exists()) {
                retval = jarFile.getCanonicalFile();
            }
        }
        return retval;
    }

    private static ClassLoader _getToolsClassLoader(ClassLoader parent) throws IOException {
        File toolsJar = JavaProcesses._findJdkJar("tools.jar");
        if (toolsJar != null && toolsJar.exists()) {
            URL toolsUrl = null;
            try {
                URI toolsURI = toolsJar.toURI();
                toolsUrl = toolsURI.toURL();
            }
            catch (MalformedURLException toolsURI) {
                // empty catch block
            }
            URL[] urls = new URL[]{toolsUrl};
            return new URLClassLoader(urls, parent);
        }
        throw new IOException("Could not find tools.jar in JDK at this location: " + toolsJar);
    }

    private static void _log(Optional<Consumer<String>> logger, String msg) {
        if (logger.isPresent()) {
            Consumer<String> consumer = logger.get();
            consumer.accept(msg);
        }
    }
}

