/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.GradleRunnerUtil;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.WorkspaceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import org.gradle.testkit.runner.BuildTask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class InitCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _workspaceDir = null;

    @Before
    public void setUp() throws Exception {
        this._workspaceDir = this.temporaryFolder.newFolder(new String[]{"build", "test", "workspace"});
    }

    @Test
    public void testBladeInitDontLoseGitDirectory() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testBladeInitDontLoseGitDirectory");
        testdir.mkdirs();
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        File gitdir = new File(projectDir, ".git");
        Assert.assertTrue((boolean)gitdir.exists());
        File oldGitIgnore = new File(projectDir, "plugins-sdk/.gitignore");
        Assert.assertTrue((boolean)oldGitIgnore.exists());
    }

    @Test
    public void testBladeInitEmptyDirectory() throws Exception {
        File emptyDir = this.temporaryFolder.newFolder();
        String[] args = new String[]{"--base", emptyDir.getPath(), "init"};
        TestUtil.runBlade(args);
        boolean workspace = WorkspaceUtil.isWorkspace((File)emptyDir);
        Assert.assertTrue((boolean)workspace);
    }

    @Test
    public void testBladeInitEmptyDirectoryHandleDot() throws Exception {
        File emptyDir = this.temporaryFolder.newFolder();
        String pathStringToTest = new File(emptyDir.getPath(), ".").getAbsolutePath();
        String[] args = new String[]{"--base", pathStringToTest, "init"};
        TestUtil.runBlade(args);
        boolean workspace = WorkspaceUtil.isWorkspace((File)emptyDir);
        Assert.assertTrue((boolean)workspace);
    }

    @Test
    public void testBladeInitEmptyDirectoryHandleTwoDots() throws Exception {
        File emptyDir = this.temporaryFolder.newFolder();
        String pathStringToTest = new File(emptyDir.getPath(), ".").getAbsolutePath();
        String[] args = new String[]{"--base", pathStringToTest, "init", "."};
        TestUtil.runBlade(args);
        boolean workspace = WorkspaceUtil.isWorkspace((File)emptyDir);
        Assert.assertTrue((boolean)workspace);
    }

    @Test
    public void testBladeInitUpgradePluginsSDKTo70() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testUpgradePluginsSDKTo70");
        testdir.mkdirs();
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        File buildProperties = new File(projectDir, "plugins-sdk/build.properties");
        Properties props = new Properties();
        props.load(new FileInputStream(buildProperties));
        String version = props.getProperty("lp.version");
        Assert.assertEquals((Object)"7.0.0", (Object)version);
    }

    @Test
    public void testBladeInitWithCustomProfile() throws Exception {
        File tempDir = this.temporaryFolder.newFolder();
        String basePath = new File(tempDir.getPath()).getAbsolutePath();
        String[] args = new String[]{"--base", basePath, "init", "-p", "myprofile"};
        TestUtil.runBlade(args);
        Assert.assertTrue((boolean)WorkspaceUtil.isWorkspace((File)tempDir));
        File settingsFile = new File(basePath, ".blade/settings.properties");
        Properties props = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(settingsFile);){
            props.load(fileInputStream);
            String profileName = props.getProperty("profile.name");
            Assert.assertEquals((Object)"myprofile", (Object)profileName);
        }
    }

    @Test
    public void testDefaultInitWorkspaceDirectoryEmpty() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        Assert.assertTrue((boolean)this._workspaceDir.exists());
        Assert.assertTrue((boolean)new File(this._workspaceDir, "build.gradle").exists());
        Assert.assertTrue((boolean)new File(this._workspaceDir, "modules").exists());
        Assert.assertFalse((boolean)new File(this._workspaceDir, "com").exists());
        this._verifyGradleBuild();
    }

    @Test
    public void testDefaultInitWorkspaceDirectoryHasFiles() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init"};
        Assert.assertTrue((boolean)new File(this._workspaceDir, "foo").createNewFile());
        BladeTest bladeTest = new BladeTest(false);
        bladeTest.run(args);
        Assert.assertFalse((boolean)new File(this._workspaceDir, "build.gradle").exists());
    }

    @Test
    public void testDefaultInitWorkspaceDirectoryHasFilesForce() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-f"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        Assert.assertTrue((boolean)this._workspaceDir.exists());
        Assert.assertTrue((boolean)new File(this._workspaceDir, "build.gradle").exists());
        Assert.assertTrue((boolean)new File(this._workspaceDir, "modules").exists());
        this._verifyGradleBuild();
    }

    @Test
    public void testDefaultInitWorkspaceDirectoryIsWorkspace() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "firstWorkspace"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        File firstWorkspace = new File(this._workspaceDir, "firstWorkspace");
        String[] moreArgs = new String[]{"--base", firstWorkspace.getPath(), "init", "nextWorkspace"};
        bladeTest = new BladeTest(false);
        bladeTest.run(moreArgs);
        Assert.assertTrue((String)(firstWorkspace.getName() + " should exist but does not."), (boolean)firstWorkspace.exists());
        File nextWorkspace = new File(this._workspaceDir + File.separator + "firstWorkspace", "nextWorkspace");
        Assert.assertFalse((String)(nextWorkspace.getName() + " should not exist, but it does."), (boolean)nextWorkspace.exists());
        try {
            BladeTestResults bladeTestResults = TestUtil.runBlade(firstWorkspace, moreArgs);
            Assert.assertFalse((String)"There should be no results from the command, but bladeTestResults != null)", (bladeTestResults != null ? 1 : 0) != 0);
        }
        catch (AssertionError e) {
            Assert.assertTrue((String)("should say 'does not support initializing a workspace inside of another workspace', but says: " + ((Throwable)((Object)e)).getMessage()), (boolean)((Throwable)((Object)e)).getMessage().contains("does not support initializing a workspace inside of another workspace"));
        }
    }

    @Test
    public void testInitCommandGradleOption() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-b", "gradle", "gradleworkspace"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        File gradleWorkspace = new File(this._workspaceDir, "gradleworkspace");
        Assert.assertTrue((boolean)gradleWorkspace.exists());
        Assert.assertFalse((boolean)new File(gradleWorkspace, "pom.xml").exists());
        Assert.assertTrue((boolean)new File(gradleWorkspace, "build.gradle").exists());
    }

    @Test
    public void testInitInPluginsSDKDirectory() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-u"};
        this._makeSDK(this._workspaceDir);
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        Assert.assertTrue((boolean)new File(this._workspaceDir, "build.gradle").exists());
        Assert.assertTrue((boolean)new File(this._workspaceDir, "modules").exists());
        Assert.assertTrue((boolean)new File(this._workspaceDir, "themes").exists());
        Assert.assertFalse((boolean)new File(this._workspaceDir, "portlets").exists());
        Assert.assertFalse((boolean)new File(this._workspaceDir, "hooks").exists());
        Assert.assertFalse((boolean)new File(this._workspaceDir, "build.properties").exists());
        Assert.assertFalse((boolean)new File(this._workspaceDir, "build.xml").exists());
        Assert.assertTrue((boolean)new File(this._workspaceDir, "plugins-sdk/build.properties").exists());
        Assert.assertTrue((boolean)new File(this._workspaceDir, "plugins-sdk/build.xml").exists());
    }

    @Test
    public void testInitWithLiferayVersion70() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-v", "7.0"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        String contents = new String(Files.readAllBytes(new File(this._workspaceDir, "gradle.properties").toPath()));
        Assert.assertTrue((String)contents, (boolean)contents.contains("7.0.6-ga7"));
        String properties = new String(Files.readAllBytes(new File(this._workspaceDir, ".blade/settings.properties").toPath()));
        Assert.assertTrue((String)properties, (boolean)properties.contains("liferay.version.default=7.0"));
    }

    @Test
    public void testInitWithLiferayVersion71() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-v", "7.1"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        String contents = new String(Files.readAllBytes(new File(this._workspaceDir, "gradle.properties").toPath()));
        Assert.assertTrue((String)contents, (boolean)contents.contains("7.1.1-ga2"));
        String properties = new String(Files.readAllBytes(new File(this._workspaceDir, ".blade/settings.properties").toPath()));
        Assert.assertTrue((String)properties, (boolean)properties.contains("liferay.version.default=7.1"));
    }

    @Test
    public void testInitWithLiferayVersionDefault() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        String contents = new String(Files.readAllBytes(new File(this._workspaceDir, "gradle.properties").toPath()));
        Assert.assertTrue((String)contents, (boolean)contents.contains("7.1.1-ga2"));
        String properties = new String(Files.readAllBytes(new File(this._workspaceDir, ".blade/settings.properties").toPath()));
        Assert.assertTrue((String)properties, (boolean)properties.contains("liferay.version.default=7.1"));
    }

    @Test
    public void testInitWithNameWorkspaceDirectoryEmpty() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-f", "newproject"};
        File newproject = new File(this._workspaceDir, "newproject");
        Assert.assertTrue((boolean)newproject.mkdirs());
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        Assert.assertTrue((boolean)new File(newproject, "build.gradle").exists());
        Assert.assertTrue((boolean)new File(newproject, "modules").exists());
        String contents = new String(Files.readAllBytes(new File(newproject, "settings.gradle").toPath()));
        Assert.assertTrue((String)contents, (boolean)contents.contains("1.10"));
    }

    @Test
    public void testInitWithNameWorkspaceDirectoryHasFiles() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "newproject"};
        Assert.assertTrue((boolean)new File(this._workspaceDir, "newproject").mkdirs());
        Assert.assertTrue((boolean)new File(this._workspaceDir, "newproject/foo").createNewFile());
        BladeTest bladeTest = new BladeTest(false);
        bladeTest.run(args);
        Assert.assertFalse((boolean)new File(this._workspaceDir, "newproject/build.gradle").exists());
    }

    @Test
    public void testInitWithNameWorkspaceNotExists() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "newproject"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        Assert.assertTrue((boolean)new File(this._workspaceDir, "newproject/build.gradle").exists());
        Assert.assertTrue((boolean)new File(this._workspaceDir, "newproject/modules").exists());
    }

    private void _createBundle() throws Exception {
        String projectPath = new File(this._workspaceDir, "modules").getAbsolutePath();
        String[] args = new String[]{"create", "-t", "mvc-portlet", "-d", projectPath, "foo"};
        BladeTest bladeTest = new BladeTest();
        bladeTest.run(args);
        File file = new File(projectPath, "/foo");
        File bndFile = new File(projectPath, "/foo/bnd.bnd");
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)bndFile.exists());
    }

    private void _makeSDK(File dir) throws IOException {
        Assert.assertTrue((boolean)new File(dir, "portlets").mkdirs());
        Assert.assertTrue((boolean)new File(dir, "hooks").mkdirs());
        Assert.assertTrue((boolean)new File(dir, "layouttpl").mkdirs());
        Assert.assertTrue((boolean)new File(dir, "themes").mkdirs());
        Assert.assertTrue((boolean)new File(dir, "build.properties").createNewFile());
        Assert.assertTrue((boolean)new File(dir, "build.xml").createNewFile());
        Assert.assertTrue((boolean)new File(dir, "build-common.xml").createNewFile());
        Assert.assertTrue((boolean)new File(dir, "build-common-plugin.xml").createNewFile());
    }

    private void _verifyGradleBuild() throws Exception {
        this._createBundle();
        String projectPath = this._workspaceDir.getPath() + "/modules";
        BuildTask buildTask = GradleRunnerUtil.executeGradleRunner(this._workspaceDir.getPath(), "jar");
        GradleRunnerUtil.verifyGradleRunnerOutput(buildTask);
        GradleRunnerUtil.verifyBuildOutput(projectPath + "/foo", "foo-1.0.0.jar");
    }
}

