/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.StringPrintStream;
import com.liferay.blade.cli.command.InstallExtensionCommand;
import com.liferay.blade.cli.gradle.GradleExec;
import com.liferay.blade.cli.gradle.ProcessResult;
import java.io.File;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.rule.PowerMockRule;

@PrepareForTest(value={InstallExtensionCommand.class})
public class GradlePrintErrorTest {
    @Rule
    public final PowerMockRule rule = new PowerMockRule();
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testGradleError() throws Exception {
        String[] args = new String[]{"extension", "install", "https://github.com/gamerson/blade-sample-command"};
        BladeTest bladeTest = new BladeTest(false);
        PowerMock.expectNew(GradleExec.class, (Object[])new Object[]{EasyMock.isA(BladeTest.class)}).andReturn((Object)new GradleExecSpecial(bladeTest));
        PowerMock.replay((Object[])new Object[]{GradleExec.class});
        bladeTest.run(args);
        StringPrintStream errPrintStream = (StringPrintStream)bladeTest.error();
        String error = errPrintStream.toString();
        Assert.assertTrue((String)error, (boolean)error.contains("BUILD FAILED"));
        Assert.assertTrue((String)error, (boolean)error.contains("foobar"));
        PowerMock.verifyAll();
    }

    private static class GradleExecSpecial
    extends GradleExec {
        public GradleExecSpecial(BladeCLI blade) {
            super(blade);
        }

        public ProcessResult executeTask(String cmd, File dir) throws Exception {
            cmd = cmd.replace("assemble", "foobar");
            return super.executeTask(cmd, dir);
        }
    }
}

