/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import aQute.bnd.osgi.Domain;
import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.LiferayBundleDeployer;
import com.liferay.blade.cli.MockUtil;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.command.DeployCommand;
import com.liferay.blade.cli.gradle.GradleExec;
import com.liferay.blade.cli.gradle.GradleTooling;
import com.liferay.blade.cli.util.BladeUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.rule.PowerMockRule;

@PrepareForTest(value={Domain.class, GradleTooling.class, LiferayBundleDeployer.class, GradleExec.class, BladeCLI.class, BladeTest.class, BladeUtil.class, DeployCommand.class, TestUtil.class})
public class DeployCommandTest {
    @Rule
    public final PowerMockRule rule = new PowerMockRule();
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testInstallExistingJar() throws Exception {
        List bundles = Collections.emptyList();
        AtomicLong atomicLong = new AtomicLong(1L);
        File jar = this._createFile("test.jar");
        MockUtil.stubGradleExec();
        MockUtil.stubDomain(true, false);
        MockUtil.stubDeployCommand();
        MockUtil.stubGradleTooling(jar);
        LiferayBundleDeployer client = (LiferayBundleDeployer)EasyMock.createNiceMock(LiferayBundleDeployer.class);
        EasyMock.expect((Object)client.getBundleId((Collection)EasyMock.eq(bundles), EasyMock.anyString())).andAnswer(() -> atomicLong.get()).atLeastOnce();
        EasyMock.expect((Object)client.getBundleId(EasyMock.anyString())).andAnswer(() -> atomicLong.get()).atLeastOnce();
        EasyMock.expect((Object)client.getBundles()).andReturn(bundles).atLeastOnce();
        Path jarPath = jar.toPath();
        EasyMock.expect((Object)client.install((URI)EasyMock.eq((Object)jarPath.toUri()))).andAnswer(() -> atomicLong.incrementAndGet()).once();
        client.reloadBundle(EasyMock.anyLong(), (URI)EasyMock.eq((Object)jarPath.toUri()));
        EasyMock.expectLastCall().andVoid().once();
        EasyMock.replay((Object[])new Object[]{client});
        PowerMock.mockStatic(LiferayBundleDeployer.class);
        EasyMock.expect((Object)LiferayBundleDeployer.newInstance((String)EasyMock.anyString(), (int)EasyMock.anyInt())).andReturn((Object)client).once();
        PowerMock.replay((Object[])new Object[]{LiferayBundleDeployer.class});
        String[] args = new String[]{"--base", jar.getParentFile().getAbsolutePath(), "deploy"};
        BladeTestResults bladeTestResults = TestUtil.runBlade(args);
        String output = bladeTestResults.getOutput();
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)output.contains(String.format("Updated bundle %s", atomicLong.get())));
    }

    @Test
    public void testInstallJar() throws Exception {
        List bundles = Collections.emptyList();
        AtomicLong atomicLong = new AtomicLong(1L);
        File jar = this._createFile("test.jar");
        MockUtil.stubGradleExec();
        MockUtil.stubDomain(true, false);
        MockUtil.stubDeployCommand();
        MockUtil.stubGradleTooling(jar);
        LiferayBundleDeployer client = (LiferayBundleDeployer)EasyMock.createNiceMock(LiferayBundleDeployer.class);
        EasyMock.expect((Object)client.getBundleId(EasyMock.anyString())).andAnswer(atomicLong::get).atLeastOnce();
        EasyMock.expect((Object)client.getBundles()).andReturn(bundles).atLeastOnce();
        Path jarPath = jar.toPath();
        EasyMock.expect((Object)client.install(jarPath.toUri())).andAnswer(() -> atomicLong.incrementAndGet()).once();
        client.start(EasyMock.eq((long)atomicLong.get()));
        EasyMock.expectLastCall().andVoid().once();
        EasyMock.replay((Object[])new Object[]{client});
        PowerMock.mockStatic(LiferayBundleDeployer.class);
        EasyMock.expect((Object)LiferayBundleDeployer.newInstance((String)EasyMock.anyString(), (int)EasyMock.anyInt())).andReturn((Object)client).once();
        PowerMock.replay((Object[])new Object[]{LiferayBundleDeployer.class});
        String[] args = new String[]{"--base", jar.getParentFile().getAbsolutePath(), "deploy"};
        String content = TestUtil.runBlade(args).getOutput();
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)content.contains(String.format("Installed bundle %s", atomicLong.get())));
    }

    @Test
    public void testInstallWar() throws Exception {
        File war = this._createFile("test.war");
        MockUtil.stubGradleExec();
        MockUtil.stubDomain(false, false);
        MockUtil.stubDeployCommand();
        MockUtil.stubGradleTooling(war);
        LiferayBundleDeployer client = (LiferayBundleDeployer)EasyMock.createNiceMock(LiferayBundleDeployer.class);
        EasyMock.expect((Object)client.install((URI)EasyMock.eq((Object)war.toURI()))).andReturn((Object)1L).once();
        client.start(1L);
        EasyMock.expectLastCall().andVoid().once();
        EasyMock.replay((Object[])new Object[]{client});
        PowerMock.mockStatic(LiferayBundleDeployer.class);
        EasyMock.expect((Object)LiferayBundleDeployer.newInstance((String)EasyMock.anyString(), (int)EasyMock.anyInt())).andReturn((Object)client).once();
        PowerMock.replay((Object[])new Object[]{LiferayBundleDeployer.class});
        String[] args = new String[]{"--base", war.getParentFile().getAbsolutePath(), "deploy"};
        new BladeTest(false).run(args);
        PowerMock.verifyAll();
    }

    private File _createFile(String fileName) throws IOException {
        File testDir = this.temporaryFolder.newFolder();
        File war = new File(testDir, fileName);
        Assert.assertTrue((boolean)war.createNewFile());
        return war;
    }
}

