/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.TestUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UninstallExtensionCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUpTestExtensions() throws Exception {
        File extensionsDir = new File(this.temporaryFolder.getRoot(), ".blade/extensions");
        extensionsDir.mkdirs();
        Assert.assertTrue((String)"Unable to create test extensions dir.", (boolean)extensionsDir.exists());
        Path extensionsPath = extensionsDir.toPath();
        UninstallExtensionCommandTest._setupTestExtension(extensionsPath, System.getProperty("sampleCommandJarFile"));
    }

    @Test
    public void testUninstallCustomExtension() throws Exception {
        File sampleCommandJarFile = new File(System.getProperty("sampleCommandJarFile"));
        String jarName = sampleCommandJarFile.getName();
        String[] args = new String[]{"extension", "uninstall", jarName};
        File extensionsDir = new File(this.temporaryFolder.getRoot(), "extensions");
        extensionsDir.mkdirs();
        File testJar = new File(extensionsDir, jarName);
        BladeTestResults bladeTestResults = TestUtil.runBlade(this.temporaryFolder.getRoot(), args);
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((output.contains(" successful") && output.contains(jarName) ? 1 : 0) != 0);
        Assert.assertTrue((!testJar.exists() ? 1 : 0) != 0);
    }

    private static void _setupTestExtension(Path extensionsPath, String jarPath) throws IOException {
        File sampleJarFile = new File(jarPath);
        Assert.assertTrue((String)(sampleJarFile.getAbsolutePath() + " does not exist."), (boolean)sampleJarFile.exists());
        Path sampleJarPath = extensionsPath.resolve(sampleJarFile.getName());
        Files.copy(sampleJarFile.toPath(), sampleJarPath, StandardCopyOption.REPLACE_EXISTING);
        Assert.assertTrue((boolean)Files.exists(sampleJarPath, new LinkOption[0]));
    }
}

