/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.StringPrintStream;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.command.ServerStartCommand;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.PidUtil;
import org.zeroturnaround.process.Processes;

public class ServerCommandsTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _workspaceDir = null;

    @Before
    public void setUp() throws Exception {
        this._workspaceDir = this.temporaryFolder.newFolder(new String[]{"build", "test", "workspace"});
    }

    @Test
    public void testServerCommands() throws Exception {
        String[] initArgs = new String[]{"--base", this._workspaceDir.getPath(), "init", "-v", "7.1"};
        new BladeTest().run(initArgs);
        String[] gwArgs = new String[]{"--base", this._workspaceDir.getPath(), "gw", "initBundle"};
        new BladeTest().run(gwArgs);
        this._testServerStart();
    }

    @Test
    public void testServerInit() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init"};
        new BladeTest().run(args);
        args = new String[]{"--base", this._workspaceDir.getPath(), "server", "init"};
        File bundlesDirectory = new File(this._workspaceDir.getPath(), "bundles");
        Assert.assertFalse((boolean)bundlesDirectory.exists());
        TestUtil.runBlade(args);
        Assert.assertTrue((boolean)bundlesDirectory.exists());
    }

    @Test
    public void testServerStartCommandExists() throws Exception {
        Assert.assertTrue((boolean)ServerCommandsTest._commandExists("server", "start"));
        Assert.assertTrue((boolean)ServerCommandsTest._commandExists("server start"));
        Assert.assertFalse((boolean)ServerCommandsTest._commandExists("server", "startx"));
        Assert.assertFalse((boolean)ServerCommandsTest._commandExists("server startx"));
        Assert.assertFalse((boolean)ServerCommandsTest._commandExists("serverx", "start"));
        Assert.assertFalse((boolean)ServerCommandsTest._commandExists("serverx start"));
    }

    @Test
    public void testServerStopCommandExists() throws Exception {
        Assert.assertTrue((boolean)ServerCommandsTest._commandExists("server", "stop"));
        Assert.assertTrue((boolean)ServerCommandsTest._commandExists("server stop"));
        Assert.assertFalse((boolean)ServerCommandsTest._commandExists("server", "stopx"));
        Assert.assertFalse((boolean)ServerCommandsTest._commandExists("server stopx"));
        Assert.assertFalse((boolean)ServerCommandsTest._commandExists("serverx", "stopx"));
        Assert.assertFalse((boolean)ServerCommandsTest._commandExists("serverx stop"));
    }

    private static boolean _commandExists(String ... args) {
        try {
            TestUtil.runBlade(args);
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            return Objects.nonNull(message) && !message.contains("No such command");
        }
        return false;
    }

    private void _testServerStart() throws Exception {
        final String[] args = new String[]{"--base", this._workspaceDir.getPath(), "server", "start"};
        StringPrintStream outputPrintStream = StringPrintStream.newInstance();
        StringPrintStream errorPrintStream = StringPrintStream.newInstance();
        final BladeTest bladeTest = new BladeTest((PrintStream)outputPrintStream, (PrintStream)errorPrintStream);
        final ArrayList exceptions = new ArrayList();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    bladeTest.run(args);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        thread.setDaemon(true);
        thread.run();
        Thread.sleep(5L);
        if (!exceptions.isEmpty()) {
            Assert.fail((String)("Unexpected exception: " + exceptions.get(0)));
        }
        ServerStartCommand serverStartCommand = (ServerStartCommand)bladeTest.getCommand();
        Collection processes = serverStartCommand.getProcesses();
        Assert.assertFalse((String)"Expected server start process to have started.", (boolean)processes.isEmpty());
        Iterator iterator = processes.iterator();
        Process process = (Process)iterator.next();
        Assert.assertTrue((String)"Expected server start process to be alive.", (boolean)process.isAlive());
        int pid = PidUtil.getPid((Process)process);
        PidProcess pidProcess = Processes.newPidProcess((int)pid);
        pidProcess.destroyForcefully();
        pidProcess.waitFor(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"Expected server start process to be destroyed.", (boolean)pidProcess.isAlive());
    }
}

