/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import aQute.bnd.osgi.Domain;
import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.Extensions;
import com.liferay.blade.cli.command.DeployCommand;
import com.liferay.blade.cli.gradle.GradleExec;
import com.liferay.blade.cli.gradle.GradleTooling;
import com.liferay.blade.cli.gradle.ProcessResult;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.gradle.tooling.ProjectInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.powermock.api.easymock.PowerMock;

public class MockUtil {
    public static void stubDeployCommand() throws Exception {
        PowerMock.mockStaticPartialNice(BladeUtil.class, (String[])new String[]{"canConnect"});
        IExpectationSetters canConnect = EasyMock.expect((Object)BladeUtil.canConnect((String)EasyMock.anyString(), (int)EasyMock.anyInt()));
        canConnect.andStubReturn((Object)true);
        HashMap<String, DeployCommand> map = new HashMap<String, DeployCommand>();
        map.put("deploy", new DeployCommand());
        Extensions extensions = (Extensions)EasyMock.createNiceMock(Extensions.class);
        EasyMock.expect((Object)extensions.getCommands()).andStubReturn(map);
        PowerMock.replay((Object[])new Object[]{Extensions.class, BladeUtil.class});
    }

    public static void stubDomain(boolean returnBsn, boolean returnFragment) throws IOException {
        PowerMock.mockStatic(Domain.class);
        EasyMock.expect((Object)Domain.domain((File)((File)EasyMock.isA(File.class)))).andStubAnswer(() -> {
            Domain domain = (Domain)EasyMock.createNiceMock(Domain.class);
            if (returnBsn || returnFragment) {
                AbstractMap.SimpleEntry<Object, Object> mock = new AbstractMap.SimpleEntry<Object, Object>(null, null);
                if (returnBsn) {
                    EasyMock.expect((Object)domain.getBundleSymbolicName()).andStubReturn(mock);
                } else {
                    EasyMock.expect((Object)domain.getBundleSymbolicName()).andStubReturn(null);
                }
                if (returnFragment) {
                    EasyMock.expect((Object)domain.getFragmentHost()).andStubReturn(mock);
                } else {
                    EasyMock.expect((Object)domain.getFragmentHost()).andStubReturn(null);
                }
            }
            EasyMock.replay((Object[])new Object[]{domain});
            return domain;
        });
        PowerMock.replay((Object[])new Object[]{Domain.class});
    }

    public static void stubGradleExec() throws Exception {
        ProcessResult result = new ProcessResult(0, "", "");
        GradleExec gradle = (GradleExec)EasyMock.createNiceMock(GradleExec.class);
        EasyMock.expect((Object)gradle.executeTask(EasyMock.anyString())).andStubReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{gradle});
        PowerMock.mockStatic(GradleExec.class);
        IExpectationSetters newGradleExec = PowerMock.expectNew(GradleExec.class, (Object[])new Object[]{EasyMock.isA(BladeTest.class)});
        newGradleExec.andStubReturn((Object)gradle);
        PowerMock.replay((Object[])new Object[]{GradleExec.class});
    }

    public static void stubGradleTooling(final File returnFile) throws Exception {
        PowerMock.mockStatic(GradleTooling.class);
        IExpectationSetters projectInfo = EasyMock.expect((Object)GradleTooling.loadProjectInfo((Path)((Path)EasyMock.isA(Path.class))));
        projectInfo.andStubReturn((Object)new ProjectInfo(){

            public Set<String> getPluginClassNames() {
                return null;
            }

            public Map<String, Set<File>> getProjectOutputFiles() {
                HashMap<String, Set<File>> map = new HashMap<String, Set<File>>();
                map.put("", Collections.singleton(returnFile));
                return map;
            }

            public boolean isLiferayProject() {
                return false;
            }
        });
        PowerMock.replay((Object[])new Object[]{GradleTooling.class});
    }
}

