/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeSettings;
import com.liferay.blade.cli.StringPrintStream;
import com.liferay.blade.cli.util.WorkspaceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class BladeTest
extends BladeCLI {
    private boolean _assertErrors = true;
    private File _userHomeDir;

    public BladeTest() throws Exception {
        super((PrintStream)StringPrintStream.newInstance(), (PrintStream)StringPrintStream.newInstance(), System.in);
        this._userHomeDir = new File(System.getProperty("user.home"));
    }

    public BladeTest(boolean assertErrors) throws Exception {
        this();
        this._assertErrors = assertErrors;
    }

    public BladeTest(File userHomeDir) throws Exception {
        this();
        this._userHomeDir = userHomeDir;
    }

    public BladeTest(PrintStream ps) {
        this(ps, ps, null);
    }

    public BladeTest(PrintStream ps, InputStream in) {
        this(ps, ps, in);
    }

    public BladeTest(PrintStream outputStream, PrintStream errorStream) {
        this(outputStream, errorStream, System.in);
    }

    public BladeTest(PrintStream outputStream, PrintStream errorStream, InputStream in) {
        this(outputStream, errorStream, in, new File(System.getProperty("user.home")), true);
    }

    public BladeTest(PrintStream out, PrintStream err, InputStream in, File userHomeDir) {
        this(out, err, in, userHomeDir, true);
    }

    public BladeTest(PrintStream out, PrintStream err, InputStream in, File userHomeDir, boolean assertErrors) {
        super(out, err, in);
        this._userHomeDir = userHomeDir;
        this._assertErrors = assertErrors;
    }

    public BladeSettings getBladeSettings() throws IOException {
        File settingsFile;
        if (WorkspaceUtil.isWorkspace((BladeCLI)this)) {
            File workspaceDir = WorkspaceUtil.getWorkspaceDir((BladeCLI)this);
            settingsFile = new File(workspaceDir, ".blade/settings.properties");
        } else {
            settingsFile = new File(this._userHomeDir, ".blade/settings.properties");
        }
        return new BladeSettings(settingsFile);
    }

    public Path getCachePath() {
        Path userHomePath = this._userHomeDir.toPath();
        Path cachePath = userHomePath.resolve(".blade/cache");
        try {
            Files.createDirectories(cachePath, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cachePath;
    }

    public Path getExtensionsPath() {
        Path userHomePath = this._userHomeDir.toPath();
        Path extensionsPath = userHomePath.resolve(".blade/extensions");
        try {
            Files.createDirectories(extensionsPath, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return extensionsPath;
    }

    public void postRunCommand() {
    }

    public void run(String[] args) throws Exception {
        PrintStream error;
        super.run(args);
        if (this._assertErrors && (error = this.error()) instanceof StringPrintStream) {
            StringPrintStream stringPrintStream = (StringPrintStream)error;
            String errors = stringPrintStream.get();
            errors = errors.replaceAll("sh: warning: setlocale: LC_ALL: cannot change locale \\(en_US.UTF-8\\)", "");
            if (!(errors = errors.trim()).isEmpty()) {
                throw new Exception("Errors not empty:\n" + errors);
            }
        }
    }
}

