/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import groovy.lang.AdaptingMetaClass;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Tuple;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.gradle.api.NonNullApi;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.InstrumentedGroovyCallsTracker;
import org.gradle.internal.classpath.ThrowAsUnchecked;
import org.gradle.internal.classpath.intercept.AbstractInvocation;
import org.gradle.internal.classpath.intercept.CallInterceptor;
import org.gradle.internal.classpath.intercept.CallInterceptorResolver;
import org.gradle.internal.classpath.intercept.InterceptScope;
import org.gradle.internal.classpath.intercept.Invocation;
import org.gradle.internal.classpath.intercept.PropertyAwareCallInterceptor;
import org.gradle.internal.classpath.intercept.SignatureAwareCallInterceptor;
import org.gradle.internal.metaobject.InstrumentedMetaClass;

@NonNullApi
public class CallInterceptingMetaClass
extends MetaClassImpl
implements AdaptingMetaClass,
InstrumentedMetaClass {
    private MetaClass adaptee;
    private final InstrumentedGroovyCallsTracker callsTracker;
    private final CallInterceptorResolver interceptorResolver;
    private static final Object[] NO_ARG = new Object[0];

    public CallInterceptingMetaClass(MetaClassRegistry registry, Class<?> javaClass, MetaClass adaptee, InstrumentedGroovyCallsTracker callsTracker, CallInterceptorResolver interceptorResolver) {
        super(registry, javaClass);
        this.adaptee = adaptee;
        this.callsTracker = callsTracker;
        this.interceptorResolver = interceptorResolver;
        super.initialize();
    }

    public Object getProperty(Class sender, Object object, String name, boolean useSuper, boolean fromInsideClass) {
        if (useSuper || fromInsideClass) {
            return this.adaptee.getProperty(sender, object, name, useSuper, fromInsideClass);
        }
        return this.invokeIntercepted(object, InstrumentedGroovyCallsTracker.CallKind.GET_PROPERTY, name, NO_ARG, () -> this.adaptee.getProperty(sender, object, name, false, false));
    }

    public Object getProperty(Object object, String property) {
        return this.invokeIntercepted(object, InstrumentedGroovyCallsTracker.CallKind.GET_PROPERTY, property, NO_ARG, () -> this.adaptee.getProperty(object, property));
    }

    public void setProperty(Class sender, Object object, String name, Object newValue, boolean useSuper, boolean fromInsideClass) {
        if (useSuper || fromInsideClass) {
            this.adaptee.setProperty(sender, object, name, newValue, useSuper, fromInsideClass);
        } else {
            this.invokeIntercepted(object, InstrumentedGroovyCallsTracker.CallKind.SET_PROPERTY, name, new Object[]{newValue}, () -> {
                this.adaptee.setProperty(sender, object, name, newValue, useSuper, fromInsideClass);
                return null;
            });
        }
    }

    public void setProperty(Object object, String property, Object newValue) {
        this.invokeIntercepted(object, InstrumentedGroovyCallsTracker.CallKind.SET_PROPERTY, property, new Object[]{newValue}, () -> {
            this.adaptee.setProperty(object, property, newValue);
            return null;
        });
    }

    @Nullable
    public MetaProperty getMetaProperty(String name) {
        Pair<String, CallInterceptor> setterCallerAndInterceptor;
        MetaProperty original = this.adaptee.getMetaProperty(name);
        Pair<String, CallInterceptor> getterCallerAndInterceptor = this.findGetterCallerAndInterceptor(name);
        Pair<String, CallInterceptor> pair = setterCallerAndInterceptor = getterCallerAndInterceptor != null ? null : this.findSetterCallerAndInterceptor(name);
        if (getterCallerAndInterceptor != null || setterCallerAndInterceptor != null) {
            String consumerClass = getterCallerAndInterceptor != null ? (String)getterCallerAndInterceptor.left : (String)setterCallerAndInterceptor.left;
            Class<?> propertyType = this.interceptedPropertyType(original, Optional.ofNullable(getterCallerAndInterceptor).map(Pair::right).orElse(null), Optional.ofNullable(setterCallerAndInterceptor).map(Pair::right).orElse(null));
            if (propertyType != null) {
                return new InterceptedMetaProperty(name, propertyType, original, this.theClass, this.callsTracker, getterCallerAndInterceptor != null ? (CallInterceptor)getterCallerAndInterceptor.right : null, setterCallerAndInterceptor != null ? (CallInterceptor)setterCallerAndInterceptor.right : null, Objects.requireNonNull(consumerClass));
            }
        }
        return original;
    }

    @Nullable
    private Class<?> interceptedPropertyType(@Nullable MetaProperty originalProperty, @Nullable CallInterceptor getterInterceptor, @Nullable CallInterceptor setterInterceptor) {
        Class typeFromSetter;
        Class typeFromGetter;
        if (getterInterceptor instanceof PropertyAwareCallInterceptor && (typeFromGetter = ((PropertyAwareCallInterceptor)getterInterceptor).matchesProperty(this.theClass)) != null) {
            return typeFromGetter;
        }
        if (setterInterceptor instanceof PropertyAwareCallInterceptor && (typeFromSetter = ((PropertyAwareCallInterceptor)setterInterceptor).matchesProperty(this.theClass)) != null) {
            return typeFromSetter;
        }
        if (originalProperty != null) {
            return originalProperty.getType();
        }
        return null;
    }

    public Object invokeMethod(Object object, String methodName, @Nullable Object arguments) {
        Object[] objectArray;
        if (arguments == null) {
            objectArray = MetaClassHelper.EMPTY_ARRAY;
        } else if (arguments instanceof Tuple) {
            objectArray = ((Tuple)arguments).toArray();
        } else if (arguments instanceof Object[]) {
            objectArray = (Object[])arguments;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = arguments;
        }
        Object[] argsForInterceptor = objectArray;
        return this.invokeIntercepted(object, InstrumentedGroovyCallsTracker.CallKind.INVOKE_METHOD, methodName, argsForInterceptor, () -> this.adaptee.invokeMethod(object, methodName, arguments));
    }

    public Object invokeMethod(Object object, String methodName, Object[] arguments) {
        return this.invokeIntercepted(object, InstrumentedGroovyCallsTracker.CallKind.INVOKE_METHOD, methodName, arguments, () -> this.adaptee.invokeMethod(object, methodName, arguments));
    }

    public Object invokeMethod(Class sender, Object object, String methodName, Object[] originalArguments, boolean isCallToSuper, boolean fromInsideClass) {
        if (isCallToSuper || fromInsideClass) {
            return this.adaptee.invokeMethod(sender, object, methodName, originalArguments, isCallToSuper, fromInsideClass);
        }
        return this.invokeIntercepted(object, InstrumentedGroovyCallsTracker.CallKind.INVOKE_METHOD, methodName, originalArguments, () -> this.adaptee.invokeMethod(sender, object, methodName, originalArguments, isCallToSuper, fromInsideClass));
    }

    public MetaMethod pickMethod(String methodName, Class[] arguments) {
        SignatureAwareCallInterceptor.SignatureMatch signatureMatch;
        CallInterceptor callInterceptor;
        String matchedCaller = this.callsTracker.findCallerForCurrentCallIfNotIntercepted(methodName, InstrumentedGroovyCallsTracker.CallKind.INVOKE_METHOD);
        MetaMethod original = this.adaptee.pickMethod(methodName, arguments);
        if (matchedCaller != null && (callInterceptor = this.interceptorResolver.resolveCallInterceptor(InterceptScope.methodsNamed((String)methodName))) instanceof SignatureAwareCallInterceptor && (signatureMatch = ((SignatureAwareCallInterceptor)callInterceptor).matchesMethodSignature(this.theClass, arguments, false)) != null) {
            return new InterceptedMetaMethod(original, methodName, this.theClass, matchedCaller, callInterceptor, signatureMatch.argClasses, signatureMatch.isVararg, this.callsTracker);
        }
        return original;
    }

    private Object invokeIntercepted(Object receiver, InstrumentedGroovyCallsTracker.CallKind kind, String name, Object[] arguments, Callable<Object> invokeOriginal) {
        String matchedCaller = this.callsTracker.findCallerForCurrentCallIfNotIntercepted(name, kind);
        if (matchedCaller != null) {
            InterceptScope scope;
            Object object = kind == InstrumentedGroovyCallsTracker.CallKind.INVOKE_METHOD ? InterceptScope.methodsNamed((String)name) : (kind == InstrumentedGroovyCallsTracker.CallKind.GET_PROPERTY ? InterceptScope.readsOfPropertiesNamed((String)name) : (scope = kind == InstrumentedGroovyCallsTracker.CallKind.SET_PROPERTY ? InterceptScope.writesOfPropertiesNamed((String)name) : null));
            if (scope == null) {
                throw new IllegalArgumentException("unexpected invocation with kind " + (Object)((Object)kind));
            }
            CallInterceptor callInterceptor = this.interceptorResolver.resolveCallInterceptor(scope);
            if (callInterceptor != null) {
                return CallInterceptingMetaClass.invokeWithInterceptor(this.callsTracker, callInterceptor, name, kind, receiver, arguments, matchedCaller, invokeOriginal);
            }
        }
        try {
            return invokeOriginal.call();
        }
        catch (Throwable e) {
            ThrowAsUnchecked.doThrow(e);
            throw new IllegalStateException("this is unreachable code, the call above should always throw an exception");
        }
    }

    public MetaClass getAdaptee() {
        return this.adaptee;
    }

    public void setAdaptee(MetaClass metaClass) {
        this.adaptee = metaClass;
    }

    public synchronized void initialize() {
        this.adaptee.initialize();
    }

    public Object invokeMissingMethod(Object instance, String methodName, Object[] arguments) {
        return this.adaptee.invokeMissingMethod(instance, methodName, arguments);
    }

    public Object invokeMissingProperty(Object instance, String propertyName, Object optionalValue, boolean isGetter) {
        return this.adaptee.invokeMissingProperty(instance, propertyName, optionalValue, isGetter);
    }

    public Object invokeConstructor(Object[] arguments) {
        return this.adaptee.invokeConstructor(arguments);
    }

    public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
        return this.adaptee.invokeStaticMethod(object, methodName, arguments);
    }

    public MetaMethod getStaticMetaMethod(String name, Object[] argTypes) {
        return this.adaptee.getStaticMetaMethod(name, argTypes);
    }

    public List<MetaMethod> respondsTo(Object obj, String name, Object[] argTypes) {
        return (List)Cast.uncheckedNonnullCast(super.respondsTo(obj, name, argTypes));
    }

    public List<MetaMethod> respondsTo(Object obj, String name) {
        return (List)Cast.uncheckedNonnullCast(super.respondsTo(obj, name));
    }

    private static Object invokeWithInterceptor(InstrumentedGroovyCallsTracker callsTracker, CallInterceptor interceptor, String name, InstrumentedGroovyCallsTracker.CallKind kind, Object receiver, Object[] arguments, String consumerClass, Callable<Object> doCallOriginal) {
        InvokedFlag invokedOriginal = new InvokedFlag();
        try {
            if (consumerClass.equals(callsTracker.findCallerForCurrentCallIfNotIntercepted(name, kind))) {
                Invocation invocation = CallInterceptingMetaClass.callOriginalReportingInvocation(receiver, arguments, doCallOriginal, invokedOriginal);
                Object object = interceptor.doIntercept(invocation, consumerClass);
                return object;
            }
            invokedOriginal.run();
            Object invocation = doCallOriginal.call();
            return invocation;
        }
        catch (Throwable throwable) {
            ThrowAsUnchecked.doThrow(throwable);
            throw new IllegalStateException("this is an unreachable statement, the call above always throws an exception");
        }
        finally {
            if (!invokedOriginal.invoked) {
                callsTracker.markCurrentCallAsIntercepted(name, kind);
            }
        }
    }

    private static Invocation callOriginalReportingInvocation(Object receiver, Object[] arguments, final Callable<Object> doCallOriginal, final Runnable reportCallOriginal) {
        @NonNullApi
        class InvocationImpl
        extends AbstractInvocation<Object> {
            public InvocationImpl(Object receiver, Object[] args) {
                super(receiver, args);
            }

            public Object callOriginal() throws Exception {
                reportCallOriginal.run();
                return doCallOriginal.call();
            }
        }
        return new InvocationImpl(receiver, arguments);
    }

    public boolean interceptsPropertyAccess(String propertyName) {
        return this.findGetterCallerAndInterceptor(propertyName) != null || this.findSetterCallerAndInterceptor(propertyName) != null;
    }

    @Nullable
    private Pair<String, CallInterceptor> findGetterCallerAndInterceptor(String propertyName) {
        String caller = this.callsTracker.findCallerForCurrentCallIfNotIntercepted(propertyName, InstrumentedGroovyCallsTracker.CallKind.GET_PROPERTY);
        if (caller == null) {
            return null;
        }
        CallInterceptor interceptor = this.interceptorResolver.resolveCallInterceptor(InterceptScope.readsOfPropertiesNamed((String)propertyName));
        if (interceptor == null) {
            return null;
        }
        return Pair.of(caller, interceptor);
    }

    @Nullable
    private Pair<String, CallInterceptor> findSetterCallerAndInterceptor(String propertyName) {
        String caller = this.callsTracker.findCallerForCurrentCallIfNotIntercepted(propertyName, InstrumentedGroovyCallsTracker.CallKind.SET_PROPERTY);
        if (caller == null) {
            return null;
        }
        CallInterceptor interceptor = this.interceptorResolver.resolveCallInterceptor(InterceptScope.writesOfPropertiesNamed((String)propertyName));
        if (interceptor == null) {
            return null;
        }
        return Pair.of(caller, interceptor);
    }

    @NonNullApi
    public static class InterceptedMetaMethod
    extends MetaMethod {
        @Nullable
        private final MetaMethod original;
        private final InstrumentedGroovyCallsTracker callsTracker;
        private final String name;
        private final Class<?> owner;
        private final String consumerClass;
        private final CallInterceptor callInterceptor;

        public InterceptedMetaMethod(@Nullable MetaMethod original, String name, Class<?> owner, String consumerClass, CallInterceptor callInterceptor, Class<?>[] nativeParameterTypes, boolean isVararg, InstrumentedGroovyCallsTracker callsTracker) {
            this.original = original;
            this.name = name;
            this.owner = owner;
            this.consumerClass = consumerClass;
            this.callInterceptor = callInterceptor;
            this.callsTracker = callsTracker;
            this.nativeParamTypes = nativeParameterTypes;
            this.isVargsMethod = isVararg;
        }

        public Object invoke(Object object, Object[] arguments) {
            return CallInterceptingMetaClass.invokeWithInterceptor(this.callsTracker, this.callInterceptor, this.name, InstrumentedGroovyCallsTracker.CallKind.INVOKE_METHOD, object, arguments, this.consumerClass, () -> {
                if (this.original != null) {
                    return this.original.invoke(object, arguments);
                }
                throw new MissingMethodException(this.name, this.owner, arguments);
            });
        }

        public int getModifiers() {
            if (this.original != null) {
                return this.original.getModifiers();
            }
            return 0;
        }

        public String getName() {
            if (this.original != null) {
                return this.original.getName();
            }
            return this.name;
        }

        public Class<?>[] getNativeParameterTypes() {
            if (this.original != null) {
                return this.original.getNativeParameterTypes();
            }
            return super.getNativeParameterTypes();
        }

        public Class<?> getReturnType() {
            if (this.original != null) {
                return this.original.getReturnType();
            }
            return Object.class;
        }

        public CachedClass getDeclaringClass() {
            if (this.original != null) {
                return this.original.getDeclaringClass();
            }
            return new CachedClass(this.owner, ClassInfo.getClassInfo(this.owner));
        }
    }

    @NonNullApi
    public static class InterceptedMetaProperty
    extends MetaProperty {
        @Nullable
        private final MetaProperty original;
        private final Class<?> ownerClass;
        private final InstrumentedGroovyCallsTracker callsTracker;
        private final CallInterceptor getterInterceptor;
        private final CallInterceptor setterInterceptor;
        private final String consumerClass;

        public InterceptedMetaProperty(String name, Class type, @Nullable MetaProperty original, Class<?> ownerClass, InstrumentedGroovyCallsTracker callsTracker, @Nullable CallInterceptor getterInterceptor, @Nullable CallInterceptor setterInterceptor, String getConsumerClass) {
            super(name, type);
            this.original = original;
            this.ownerClass = ownerClass;
            this.callsTracker = callsTracker;
            this.getterInterceptor = getterInterceptor;
            this.setterInterceptor = setterInterceptor;
            this.consumerClass = getConsumerClass;
        }

        public Object getProperty(Object object) {
            if (this.getterInterceptor != null) {
                return CallInterceptingMetaClass.invokeWithInterceptor(this.callsTracker, this.getterInterceptor, this.name, InstrumentedGroovyCallsTracker.CallKind.GET_PROPERTY, object, NO_ARG, this.consumerClass, () -> {
                    if (this.original != null) {
                        return this.original.getProperty(object);
                    }
                    throw new MissingPropertyException(this.name);
                });
            }
            if (this.original != null) {
                return this.original.getProperty(object);
            }
            throw new MissingPropertyException(this.name, this.ownerClass);
        }

        public void setProperty(Object object, Object newValue) {
            if (this.setterInterceptor != null) {
                CallInterceptingMetaClass.invokeWithInterceptor(this.callsTracker, this.setterInterceptor, this.name, InstrumentedGroovyCallsTracker.CallKind.SET_PROPERTY, object, new Object[]{newValue}, this.consumerClass, () -> {
                    if (this.original != null) {
                        this.original.setProperty(object, newValue);
                        return null;
                    }
                    throw new MissingPropertyException(this.name);
                });
            } else if (this.original != null) {
                this.original.setProperty(object, newValue);
            } else {
                throw new MissingPropertyException(this.name, this.ownerClass);
            }
        }
    }

    @NonNullApi
    static class InvokedFlag
    implements Runnable {
        public boolean invoked = false;

        InvokedFlag() {
        }

        @Override
        public void run() {
            this.invoked = true;
        }
    }
}

