/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.blade.cli.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.Objects;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.RedirectLocations;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.BasicHttpContext;

public class ResourceUtil {
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private static boolean _trace;

    public static Resolver getClassLoaderResolver(String resourcePath) {
        return () -> {
            ResourceUtil._print("Trying to get resource from class path: %s", resourcePath);
            return Objects.requireNonNull(ResourceUtil.class.getResourceAsStream(resourcePath), "Unable to get resource from class path: " + resourcePath);
        };
    }

    public static Resolver getLocalFileResolver(File file) {
        return () -> {
            ResourceUtil._print("Trying to get resource from local file: %s", file.getAbsolutePath());
            ResourceUtil._checkFileExists(file);
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        };
    }

    public static Resolver getLocalFileResolver(File file, long maxAge, TemporalUnit temporalUnit) {
        return () -> {
            ResourceUtil._print("Trying to get resource from local file with max age of %s %s: %s", maxAge, temporalUnit, file.getAbsolutePath());
            ResourceUtil._checkFileExists(file);
            BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = basicFileAttributes.lastModifiedTime();
            Duration age = Duration.between(fileTime.toInstant(), Instant.now());
            if (age.compareTo(Duration.of(maxAge, temporalUnit)) > 0) {
                throw new Exception(String.format("Cached file %s is older than max age of %s %s", file, maxAge, temporalUnit));
            }
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        };
    }

    public static Resolver getLocalFileResolver(String file) {
        if (StringUtil.isNullOrEmpty(file)) {
            return () -> null;
        }
        return ResourceUtil.getLocalFileResolver(new File(file));
    }

    public static Resolver getURIResolver(File cacheDir, URI uri, String targetFileName) {
        return () -> {
            ResourceUtil._print("Trying to get resource from URL %s", uri);
            URL url = uri.toURL();
            try {
                Path path = ResourceUtil._downloadFile(url.toString(), cacheDir.toPath(), targetFileName);
                Files.setLastModifiedTime(path, FileTime.from(Instant.now()));
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (Exception exception) {
                throw new Exception(String.format("Unable to get resource from URL %s: %s", url, exception.getMessage()), exception);
            }
        };
    }

    public static Resolver getURLResolver(File cacheDir, String url, String targetFileName) {
        return ResourceUtil.getURIResolver(cacheDir, URI.create(url), targetFileName);
    }

    public static <T> T readJson(Class<T> clazz, Resolver ... resolvers) {
        return (T)ResourceUtil._withInputStream(inputStream -> _objectMapper.readValue(inputStream, clazz), resolvers);
    }

    public static void setTrace(boolean trace) {
        _trace = trace;
    }

    private static void _checkFileExists(File file) throws Exception {
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to get resource from local file: " + file.getAbsolutePath());
        }
    }

    private static void _checkResponseStatus(HttpResponse httpResponse) throws IOException {
        if (httpResponse.getCode() != 200) {
            throw new IOException(httpResponse.getReasonPhrase());
        }
    }

    private static Path _downloadFile(CloseableHttpClient closeableHttpClient, URI uri, Path cacheDirPath, String targetFileName) throws Exception {
        Date lastModifiedDate;
        HttpHead httpHead = new HttpHead(uri);
        BasicHttpContext httpContext = new BasicHttpContext();
        try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((ClassicHttpRequest)httpHead, httpContext);){
            Header lastModifiedHeader;
            RedirectLocations redirectLocations;
            ResourceUtil._checkResponseStatus(closeableHttpResponse);
            Header dispositionHeader = closeableHttpResponse.getFirstHeader("Content-Disposition");
            if (dispositionHeader == null && (redirectLocations = (RedirectLocations)httpContext.getAttribute("http.protocol.redirect-locations")) != null && redirectLocations.size() > 0) {
                uri = redirectLocations.get(redirectLocations.size() - 1);
            }
            lastModifiedDate = (lastModifiedHeader = closeableHttpResponse.getFirstHeader("Last-Modified")) != null ? DateUtils.parseDate(lastModifiedHeader.getValue()) : new Date();
        }
        Files.createDirectories(cacheDirPath, new FileAttribute[0]);
        Path targetPath = cacheDirPath.resolve(targetFileName);
        if (Files.exists(targetPath, new LinkOption[0])) {
            FileTime fileTime = Files.getLastModifiedTime(targetPath, new LinkOption[0]);
            if (fileTime.toMillis() == lastModifiedDate.getTime()) {
                return targetPath;
            }
            Files.delete(targetPath);
        }
        HttpGet httpGet = new HttpGet(uri);
        try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpGet);){
            ResourceUtil._checkResponseStatus(closeableHttpResponse);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            try (InputStream inputStream = httpEntity.getContent();
                 OutputStream outputStream = Files.newOutputStream(targetPath, new OpenOption[0]);){
                byte[] buffer = new byte[10240];
                int read = -1;
                while ((read = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, read);
                }
            }
        }
        Files.setLastModifiedTime(targetPath, FileTime.fromMillis(lastModifiedDate.getTime()));
        return targetPath;
    }

    private static Path _downloadFile(String urlString, Path cacheDirPath, String targetFileName) throws Exception {
        URL downladURL = new URL(urlString);
        URI downladURI = downladURL.toURI();
        if (Objects.equals(downladURI.getScheme(), "file")) {
            return Paths.get(downladURI);
        }
        try (CloseableHttpClient closeableHttpClient = ResourceUtil._getHttpClient(downladURL.toURI(), null, null);){
            Path path = ResourceUtil._downloadFile(closeableHttpClient, downladURI, cacheDirPath, targetFileName);
            return path;
        }
    }

    private static CloseableHttpClient _getHttpClient(URI uri, String userName, String password) {
        String proxyPassword;
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setCookieSpec(RequestConfig.DEFAULT.getCookieSpec());
        requestConfigBuilder.setRedirectsEnabled(true);
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        String scheme = uri.getScheme();
        String proxyHost = System.getProperty(scheme + ".proxyHost");
        String proxyPort = System.getProperty(scheme + ".proxyPort");
        String proxyUser = userName;
        if (Objects.isNull(proxyUser)) {
            proxyUser = System.getProperty(scheme + ".proxyUser");
        }
        if (Objects.isNull(proxyPassword = password)) {
            proxyPassword = System.getProperty(scheme + ".proxyPassword");
        }
        if (proxyUser != null && proxyPassword != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (proxyHost != null && proxyPort != null) {
                credentialsProvider.setCredentials(new AuthScope(proxyHost, Integer.parseInt(proxyPort)), new UsernamePasswordCredentials(proxyUser, proxyPassword.toCharArray()));
            }
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        } else if (proxyHost != null && proxyPort != null) {
            httpClientBuilder.setProxy(new HttpHost(proxyHost, Integer.parseInt(proxyPort)));
        }
        httpClientBuilder.useSystemProperties();
        return httpClientBuilder.build();
    }

    private static void _print(String message, Object ... args) {
        if (_trace) {
            System.out.printf(message + "%n", args);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T _withInputStream(Transformer<T> transformer, Resolver ... resolvers) {
        InputStream inputStream1 = null;
        for (Resolver resolver : resolvers) {
            try {
                inputStream1 = resolver.resolve();
            }
            catch (Exception exception) {
                ResourceUtil._print(exception.getMessage(), new Object[0]);
            }
            if (inputStream1 != null) break;
        }
        if (inputStream1 == null) {
            ResourceUtil._print("Resource not found", new Object[0]);
            return null;
        }
        try (InputStream inputStream2 = inputStream1;){
            ResourceUtil._print("Found resource", new Object[0]);
            T t = transformer.transform(inputStream2);
            return t;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to read resource", exception);
        }
    }

    @FunctionalInterface
    public static interface Transformer<T> {
        public T transform(InputStream var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Resolver {
        public InputStream resolve() throws Exception;
    }
}

