/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CombinedClassLoader
extends ClassLoader
implements AutoCloseable {
    private Collection<ClassLoader> _classLoaders = new ArrayList<ClassLoader>();

    public CombinedClassLoader(ClassLoader ... classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            this._add(classLoader);
        }
    }

    @Override
    public void close() throws Exception {
        for (ClassLoader classLoader : this._classLoaders) {
            try {
                if (!(classLoader instanceof Closeable)) continue;
                Closeable closeable = (Closeable)((Object)classLoader);
                closeable.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/');
        URL url = this.findResource(path = path + ".class");
        if (url == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            ByteBuffer byteCode = this._loadResourceFromClasspath(url);
            return this.defineClass(name, byteCode, null);
        }
        catch (IOException ioException) {
            throw new ClassNotFoundException(name, ioException);
        }
    }

    @Override
    protected URL findResource(String name) {
        Stream<ClassLoader> urlStream = this._classLoaders.stream();
        return urlStream.map(c -> c.getResource(name)).filter(Objects::nonNull).findAny().orElse(null);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Stream<ClassLoader> urlStream = this._classLoaders.stream();
        return Collections.enumeration(urlStream.map(c -> this._getResources((ClassLoader)c, name)).map(Collections::list).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private void _add(ClassLoader classLoader) {
        this._classLoaders.add(classLoader);
    }

    private Enumeration<URL> _getResources(ClassLoader classLoader, String name) {
        try {
            return classLoader.getResources(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private ByteBuffer _loadResourceFromClasspath(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(buffer.length);
            int bytesCount = -1;
            while ((bytesCount = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesCount);
            }
            byte[] output = byteArrayOutputStream.toByteArray();
            ByteBuffer byteBuffer = ByteBuffer.wrap(output);
            return byteBuffer;
        }
    }
}

