/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command.validator;

import com.liferay.blade.cli.command.CreateArgs;
import com.liferay.blade.cli.command.validator.ValidatorFunctionPredicate;
import com.liferay.blade.cli.util.Constants;
import com.liferay.blade.cli.util.ListUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class JsProjectTypeValidator
implements ValidatorFunctionPredicate<CreateArgs> {
    @Override
    public List<String> apply(CreateArgs createArgs) {
        if (Objects.equals(createArgs.getJsProjectTarget(), Constants.DEFAULT_POSSIBLE_TARGET_VALUES[1])) {
            return Arrays.asList(Constants.DEFAULT_POSSIBLE_PROJECT_TYPE_VALUES[2]);
        }
        return Arrays.asList(Constants.DEFAULT_POSSIBLE_PROJECT_TYPE_VALUES);
    }

    @Override
    public boolean test(CreateArgs createArgs) {
        if (Objects.equals(createArgs.getTemplate(), "js-widget")) {
            boolean jsInteractiveModel = createArgs.isJsInteractiveModel();
            if (jsInteractiveModel) {
                return true;
            }
            String jsProjectType = createArgs.getJsProjectType();
            if (Objects.isNull(jsProjectType)) {
                return false;
            }
            if (Objects.equals(createArgs.getJsProjectTarget(), Constants.DEFAULT_POSSIBLE_TARGET_VALUES[1]) ? !Objects.equals(jsProjectType, Constants.DEFAULT_POSSIBLE_PROJECT_TYPE_VALUES[2]) : !ListUtil.contains(Arrays.asList(Constants.DEFAULT_POSSIBLE_PROJECT_TYPE_VALUES), jsProjectType)) {
                return false;
            }
        }
        return true;
    }
}

