/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.CommandType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Parameters(commandDescription="Watch for changes to workspace projects and automatically build, deploy, or update them into running Liferay instance.", commandNames={"watch"})
public class WatchArgs
extends BaseArgs {
    private static final List<String> _defaultFastPaths = Arrays.asList("**/*.css", "**/*.js", "**/*.jsp", "**/*.map", "**/*.scss");
    private static final List<String> _defaultIgnorePaths = Arrays.asList(".gradle", ".idea", ".settings", "**/.sass-cache", "**/bin", "**/build", "**/classes", "**/dist", "**/liferay-theme.json", "**/node_modules", "**/liferay-npm-bundler-report.html", "**/target", "bundles", "gradle");
    private static final List<String> _defaultProjectPaths = Arrays.asList("src");
    @Parameter(description="File paths that will use deployFast instead of deploy.", names={"-f", "--fast-paths"})
    private List<String> _fastPaths = new ArrayList<String>();
    @Parameter(description="Ignored watch paths.", names={"-i", "--ignore-paths"})
    private List<String> _ignorePaths = new ArrayList<String>();
    @Parameter(description="File paths to use to identify a project path.", names={"-p", "--project-paths"})
    private List<String> _projectPaths = new ArrayList<String>();
    @Parameter(description="Skip initial deploy", names={"-s", "--skip-init"})
    private boolean _skipInit = false;

    @Override
    public CommandType getCommandType() {
        return CommandType.WORKSPACE_ONLY;
    }

    public List<String> getFastPaths() {
        return Stream.concat(_defaultFastPaths.stream(), this._fastPaths.stream()).collect(Collectors.toList());
    }

    public List<String> getIgnorePaths() {
        return Stream.concat(_defaultIgnorePaths.stream(), this._ignorePaths.stream()).collect(Collectors.toList());
    }

    public List<String> getProjectPaths() {
        return Stream.concat(_defaultProjectPaths.stream(), this._projectPaths.stream()).collect(Collectors.toList());
    }

    public boolean isSkipInit() {
        return this._skipInit;
    }

    public void setFastPaths(List<String> fastPaths) {
        this._fastPaths.addAll(fastPaths);
    }

    public void setIgnorePaths(List<String> ignorePaths) {
        this._ignorePaths.addAll(ignorePaths);
    }

    public void setProjectPaths(List<String> projectPaths) {
        this._projectPaths.addAll(projectPaths);
    }

    public void setSkipInit(boolean skipInit) {
        this._skipInit = skipInit;
    }
}

