/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.LocalServer;
import com.liferay.blade.cli.command.ServerStopArgs;
import com.liferay.blade.cli.util.BladeUtil;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class ServerStopCommand
extends BaseCommand<ServerStopArgs> {
    @Override
    public void execute() throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        LocalServer localServer = this.newLocalServer(bladeCLI);
        Path liferayHomePath = localServer.getLiferayHomePath();
        if (Files.notExists(liferayHomePath, new LinkOption[0]) || BladeUtil.isDirEmpty(liferayHomePath)) {
            bladeCLI.error("Liferay home directory does not exist. Execute 'blade server init' to create it.");
            return;
        }
        String serverType = localServer.getServerType();
        if (!localServer.isSupported()) {
            bladeCLI.error(serverType + " not supported");
            return;
        }
        if (serverType.equals("jboss") || serverType.equals("wildfly")) {
            bladeCLI.error(serverType + " does not support stop command.");
            return;
        }
        ProcessBuilder processBuilder = localServer.newLocalServerProcess();
        List<String> commands = processBuilder.command();
        if (serverType.equals("tomcat")) {
            commands.add("stop");
            commands.add("60");
            commands.add("-force");
        }
        Process process = processBuilder.start();
        BladeUtil.readProcessStream(process.getInputStream(), bladeCLI.out());
        BladeUtil.readProcessStream(process.getErrorStream(), bladeCLI.error());
        OutputStream outputStream = process.getOutputStream();
        outputStream.close();
        process.waitFor();
    }

    @Override
    public Class<ServerStopArgs> getArgsClass() {
        return ServerStopArgs.class;
    }

    protected LocalServer newLocalServer(BladeCLI bladeCLI) {
        return new LocalServer(bladeCLI);
    }
}

