/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.SamplesClientExtensionArgs;
import com.liferay.blade.cli.command.SamplesVisitor;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class SamplesClientExtensionCommand
extends BaseCommand<SamplesClientExtensionArgs> {
    private static final File _USER_HOME_DIR = new File(System.getProperty("user.home"));
    private final String _clientExtensionSampleName = "client-extension-samples";

    @Override
    public void execute() throws Exception {
        SamplesClientExtensionArgs samplesClientExtensionArgs = (SamplesClientExtensionArgs)this.getArgs();
        String sampleArchiveName = "client-extension-samples.zip";
        String clientExtensionSampleUrl = "https://repository.liferay.com/nexus/service/local/artifact/maven/content?r=liferay-public-releases&g=com.liferay.workspace&a=com.liferay.sample.workspace&v=LATEST&p=zip";
        Path sampleArchivePath = BladeUtil.downloadFile("https://repository.liferay.com/nexus/service/local/artifact/maven/content?r=liferay-public-releases&g=com.liferay.workspace&a=com.liferay.sample.workspace&v=LATEST&p=zip", this._getSamplesCachePath(), "client-extension-samples.zip");
        this._extractSamplesClientExtension(sampleArchivePath);
        boolean listAllClientExtension = samplesClientExtensionArgs.isListAllCientExtensions();
        if (listAllClientExtension) {
            this._listSamples("client-extension-samples");
            return;
        }
        String sampleName = samplesClientExtensionArgs.getSampleName();
        if (sampleName != null) {
            this._copySample(sampleName, "client-extension-samples");
        } else {
            this._copySample(null, "client-extension-samples");
        }
    }

    @Override
    public Class<SamplesClientExtensionArgs> getArgsClass() {
        return SamplesClientExtensionArgs.class;
    }

    private void _copySample(String sampleName, String samplesClientExtensionRepoName) throws Exception {
        SamplesClientExtensionArgs samplesClientExtensionArgs = (SamplesClientExtensionArgs)this.getArgs();
        File workDir = samplesClientExtensionArgs.getDir();
        if (workDir == null) {
            workDir = new File(samplesClientExtensionArgs.getBase(), "client-extensions");
        }
        if (!workDir.exists()) {
            workDir.mkdir();
        }
        Path cachePath = this._getSamplesCachePath();
        File samplesClientExtensionRepo = new File(cachePath.toFile(), samplesClientExtensionRepoName + "/client-extensions");
        for (File file : samplesClientExtensionRepo.listFiles()) {
            String fileName = file.getName();
            if (!Files.isDirectory(file.toPath(), new LinkOption[0]) || !Objects.isNull(sampleName) && !fileName.equals(sampleName)) continue;
            File dest = new File(workDir, fileName);
            FileUtil.copyDir(file.toPath(), dest.toPath());
        }
    }

    private void _extractSamplesClientExtension(Path samplesArchivePath) throws Exception {
        Path samplesCachePath = this._getSamplesCachePath();
        File samplesExtractDir = new File(samplesCachePath.toFile(), "client-extension-samples");
        if (samplesExtractDir.exists()) {
            samplesExtractDir.delete();
        }
        FileUtil.unzip(samplesArchivePath.toFile(), samplesExtractDir, null);
    }

    private Path _getSamplesCachePath() throws Exception {
        Path userHomePath = _USER_HOME_DIR.toPath();
        Path samplesCachePath = userHomePath.resolve(".blade/cache/samples");
        if (!Files.exists(samplesCachePath, new LinkOption[0])) {
            Files.createDirectories(samplesCachePath, new FileAttribute[0]);
        }
        return samplesCachePath;
    }

    private void _listSamples(String samplesRepoName) throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        Path cachePath = this._getSamplesCachePath();
        File samplesClientExtensionRepo = new File(cachePath.toFile(), samplesRepoName + "/client-extensions");
        HashMap samplesMap = new HashMap();
        for (File file : samplesClientExtensionRepo.listFiles()) {
            String fileName = file.getName();
            if (!file.isDirectory()) continue;
            Files.walkFileTree(file.toPath(), new SamplesVisitor());
            ArrayList samplesList = (ArrayList)samplesMap.get(fileName);
            if (samplesList == null) {
                samplesList = new ArrayList();
                samplesMap.put(fileName, samplesList);
            }
            if (!samplesMap.containsKey(fileName)) continue;
            Collections.sort(samplesList);
        }
        bladeCLI.out("Specify client extension sample to download (\"blade samples client-extensions sample-global-css\"). Otherwise (\"blade samples client-extensions\") will download all available client extension samples.\n");
        bladeCLI.out("Currently available samples:");
        Set keySet = samplesMap.keySet();
        Stream stream = keySet.stream();
        stream.sorted().peek(category -> bladeCLI.out("\t " + category)).map(samplesMap::get).flatMap(category -> category.stream()).forEach(sample -> bladeCLI.out("\t\t " + sample));
    }
}

