/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.ConvertArgs;
import com.liferay.blade.cli.command.CreateCommand;
import com.liferay.blade.cli.gradle.GradleWorkspaceProvider;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.project.templates.extensions.ProjectTemplatesArgs;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ConvertServiceBuilderCommand {
    public static final String DESCRIPTION = "Convert a service builder project to new Liferay Workspace projects";
    private BladeCLI _bladeCLI;
    private ConvertArgs _convertArgs;
    private final List<Path> _convertedPaths = new ArrayList<Path>();
    private final File _modulesDir;

    public ConvertServiceBuilderCommand(BladeCLI bladeCLI, ConvertArgs convertArgs) throws Exception {
        this._bladeCLI = bladeCLI;
        this._convertArgs = convertArgs;
        File baseDir = this._convertArgs.getBase();
        GradleWorkspaceProvider gradleWorkspaceProvider = (GradleWorkspaceProvider)this._bladeCLI.getWorkspaceProvider(baseDir);
        File projectDir = gradleWorkspaceProvider.getWorkspaceDir(this._bladeCLI);
        Properties gradleProperties = gradleWorkspaceProvider.getGradleProperties(projectDir);
        String modulesDirPath = null;
        if (gradleProperties != null) {
            modulesDirPath = gradleProperties.getProperty("liferay.workspace.modules.dir");
        }
        if (modulesDirPath == null) {
            modulesDirPath = "modules";
        }
        this._modulesDir = new File(projectDir, modulesDirPath);
    }

    public void execute() throws Exception {
        Path modulesPath;
        Path sbProjectPath;
        String projectName;
        File baseDir = this._convertArgs.getBase();
        GradleWorkspaceProvider workspaceProvider = (GradleWorkspaceProvider)this._bladeCLI.getWorkspaceProvider(baseDir);
        if (workspaceProvider == null) {
            this._bladeCLI.error("Please execute command in a Liferay Workspace project");
            return;
        }
        List<String> name = this._convertArgs.getName();
        String string = projectName = name.isEmpty() ? null : name.get(0);
        if (projectName == null) {
            this._bladeCLI.error("Please specify a plugin name");
            return;
        }
        File pluginsSDKDir = this._getPluginsSdkDir(this._convertArgs, baseDir, workspaceProvider.getGradleProperties(baseDir));
        Path pluginsSDKPath = pluginsSDKDir.toPath();
        Path originalProjectPath = pluginsSDKPath.resolve("portlets/" + projectName);
        if (Files.notExists(originalProjectPath, new LinkOption[0])) {
            this._bladeCLI.error("The project " + projectName + " does not exist in " + originalProjectPath);
            return;
        }
        Path serviceXmlPath = originalProjectPath.resolve("docroot/WEB-INF/service.xml");
        if (Files.notExists(serviceXmlPath, new LinkOption[0])) {
            this._bladeCLI.error("There is no service.xml file in " + projectName);
            return;
        }
        List<String> args = name;
        String sbProjectName = null;
        if (args.contains("true") || args.contains("false")) {
            sbProjectName = !args.isEmpty() && args.size() >= 3 ? args.get(1) : null;
        } else {
            String string2 = sbProjectName = !args.isEmpty() && args.size() >= 2 ? args.get(1) : null;
        }
        if (sbProjectName == null) {
            sbProjectName = projectName.endsWith("-portlet") ? projectName.replaceAll("-portlet$", "") : projectName;
        }
        if (Files.exists(sbProjectPath = (modulesPath = this._modulesDir.toPath()).resolve(sbProjectName), new LinkOption[0])) {
            this._bladeCLI.error("The service builder module project " + sbProjectName + " already exists. Please choose another name");
            return;
        }
        ServiceBuilder oldServiceBuilderXml = new ServiceBuilder(serviceXmlPath.toFile());
        CreateCommand createCommand = new CreateCommand(this._bladeCLI);
        ProjectTemplatesArgs projectTemplatesArgs = new ProjectTemplatesArgs();
        Path sbProjectFileName = sbProjectPath.getFileName();
        projectTemplatesArgs.setDestinationDir(this._modulesDir);
        projectTemplatesArgs.setName(sbProjectFileName.toString());
        projectTemplatesArgs.setPackageName(oldServiceBuilderXml.getPackagePath());
        projectTemplatesArgs.setTemplate("service-builder");
        Optional<String> product = Optional.ofNullable(workspaceProvider.getProduct(baseDir));
        projectTemplatesArgs.setLiferayProduct(product.orElse(this._convertArgs.getLiferayProduct()));
        createCommand.execute(projectTemplatesArgs);
        Path sbServiceProjectPath = sbProjectPath.resolve(sbProjectName + "-service");
        Path newServiceXmlPath = sbServiceProjectPath.resolve("service.xml");
        FileUtil.copyFile(serviceXmlPath, newServiceXmlPath);
        ServiceBuilder serviceBuilderXml = new ServiceBuilder(newServiceXmlPath.toFile());
        String sbPackageName = serviceBuilderXml.getPackagePath();
        String packageName = sbPackageName.replaceAll("\\.", "/");
        Path oldSBFolder = originalProjectPath.resolve("docroot/WEB-INF/src/" + packageName);
        Path newSBFolder = sbServiceProjectPath.resolve("src/main/java/" + packageName);
        Path oldServiceImplFolder = oldSBFolder.resolve("service");
        Path newServiceImplFolder = newSBFolder.resolve("service");
        if (Files.exists(oldServiceImplFolder, new LinkOption[0])) {
            Files.createDirectories(newServiceImplFolder, new FileAttribute[0]);
            FileUtil.copyFile(oldServiceImplFolder, newServiceImplFolder);
        }
        Path oldModelImplFolder = oldSBFolder.resolve("model");
        Path newModelImplFolder = newSBFolder.resolve("model");
        if (Files.exists(oldModelImplFolder, new LinkOption[0])) {
            Files.createDirectories(newModelImplFolder, new FileAttribute[0]);
            FileUtil.copyFile(oldModelImplFolder, newModelImplFolder);
        }
        Path oldMetaInfFolder = originalProjectPath.resolve("docroot/WEB-INF/src/META-INF/");
        Path newMetaInfFolder = sbServiceProjectPath.resolve("src/main/resources/META-INF/");
        if (Files.exists(oldMetaInfFolder, new LinkOption[0])) {
            Files.createDirectories(newMetaInfFolder, new FileAttribute[0]);
            FileUtil.copyFile(oldMetaInfFolder.resolve("portlet-model-hints.xml"), newMetaInfFolder.resolve("portlet-model-hints.xml"));
        }
        Path oldSrcFolder = originalProjectPath.resolve("docroot/WEB-INF/src/");
        Path newResourcesSrcFolder = sbServiceProjectPath.resolve("src/main/resources/");
        if (Files.exists(oldSrcFolder, new LinkOption[0])) {
            Files.createDirectories(newResourcesSrcFolder, new FileAttribute[0]);
            FileUtil.copyFile(oldSrcFolder.resolve("service.properties"), newResourcesSrcFolder.resolve("service.properties"));
        }
        Path sbApiProjectPath = sbProjectPath.resolve(sbProjectName + "-api");
        Path oldApiFolder = originalProjectPath.resolve("docroot/WEB-INF/service/");
        if (Files.exists(oldApiFolder, new LinkOption[0])) {
            Path newApiPath = sbApiProjectPath.resolve("src/main/java/");
            Files.createDirectories(newApiPath, new FileAttribute[0]);
            try (Stream<Path> files = Files.list(oldApiFolder);){
                files.forEach(oldApiFile -> {
                    try {
                        FileUtil.copyFile(oldApiFile, newApiPath.resolve(oldApiFile.getFileName()));
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace(this._bladeCLI.error());
                    }
                });
            }
        }
        this._convertedPaths.add(sbApiProjectPath);
        this._convertedPaths.add(sbServiceProjectPath);
        Stream<Path> srcPaths = Files.walk(sbApiProjectPath.resolve("src/main/java/"), new FileVisitOption[0]);
        srcPaths.map(path -> path.toFile()).filter(file -> this._isJavaFile((File)file) && this._isInExportedApiFolder((File)file)).map(file -> {
            Path filePath = file.toPath();
            Path sibling = filePath.resolveSibling("packageinfo");
            return sibling.toFile();
        }).filter(file -> !file.exists()).forEach(file -> {
            try {
                Files.write(file.toPath(), "version 1.0.0".getBytes(), new OpenOption[0]);
            }
            catch (IOException ioException) {
                ioException.printStackTrace(this._bladeCLI.error());
            }
        });
        srcPaths.close();
        Path gradlePath = sbServiceProjectPath.resolve("build.gradle");
        String gradleContent = new String(Files.readAllBytes(gradlePath));
        StringBuilder sb = new StringBuilder();
        sb.append("dependencies {\n");
        sb.append("\tcompileOnly project(\":modules:");
        sb.append(sbProjectPath.getFileName());
        sb.append(":");
        sb.append(sbApiProjectPath.getFileName());
        sb.append("\")");
        sb.append(System.lineSeparator());
        String updatedContent = gradleContent.replaceAll("dependencies \\{", sb.toString());
        Files.write(gradlePath, updatedContent.getBytes(), new OpenOption[0]);
    }

    public List<Path> getConvertedPaths() {
        return this._convertedPaths;
    }

    private File _getPluginsSdkDir(ConvertArgs convertArgs, File projectDir, Properties gradleProperties) {
        File pluginsSdkDir = convertArgs.getSource();
        if (pluginsSdkDir == null) {
            String pluginsSdkDirValue;
            if (gradleProperties != null && (pluginsSdkDirValue = gradleProperties.getProperty("liferay.workspace.plugins.sdk.dir")) != null) {
                pluginsSdkDir = new File(projectDir, pluginsSdkDirValue);
            }
            if (pluginsSdkDir == null) {
                pluginsSdkDir = new File(projectDir, "plugins-sdk");
            }
        }
        return pluginsSdkDir;
    }

    private boolean _isInExportedApiFolder(File file) {
        File dir = file.getParentFile();
        String dirName = dir.getName();
        return dirName.equals("exception") || dirName.equals("model") || dirName.equals("service") || dirName.equals("persistence");
    }

    private boolean _isJavaFile(File file) {
        String name = file.getName();
        return file.isFile() && name.endsWith(".java");
    }

    private static class ServiceBuilder {
        public static final String API_62 = "docroot/WEB-INF/service/";
        public static final String META_INF = "META-INF/";
        public static final String PORTLET_MODEL_HINTS_XML = "portlet-model-hints.xml";
        public static final String SERVICE_PROPERTIES = "service.properties";
        public static final String SERVICE_XML = "service.xml";
        private Element _rootElement;
        private File _serviceXml;

        public ServiceBuilder(File serviceXml) throws Exception {
            this._serviceXml = serviceXml;
            this._parse();
        }

        public String getPackagePath() {
            return this._rootElement.getAttribute("package-path");
        }

        private void _parse() throws Exception {
            if (this._rootElement == null && this._serviceXml != null && this._serviceXml.exists()) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) {
                        return new InputSource(new StringReader(""));
                    }
                });
                Document doc = documentBuilder.parse(this._serviceXml);
                this._rootElement = doc.getDocumentElement();
            }
        }
    }
}

