/*
 * Decompiled with CFR 0.152.
 */
package org.vudroid.core;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.TextPaint;
import org.vudroid.core.DocumentView;
import org.vudroid.core.PageTreeNode;

class Page {
    final int index;
    RectF bounds;
    private PageTreeNode node;
    private DocumentView documentView;
    private final TextPaint textPaint = this.textPaint();
    private final Paint fillPaint = this.fillPaint();
    private final Paint strokePaint = this.strokePaint();
    private float aspectRatio;

    Page(DocumentView documentView, int index) {
        this.documentView = documentView;
        this.index = index;
        this.node = new PageTreeNode(documentView, new RectF(0.0f, 0.0f, 1.0f, 1.0f), this, 1, null);
    }

    float getPageHeight(int mainWidth, float zoom) {
        return (float)mainWidth / this.getAspectRatio() * zoom;
    }

    public int getTop() {
        return Math.round(this.bounds.top);
    }

    public void draw(Canvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        canvas.drawRect(this.bounds, this.fillPaint);
        canvas.drawText("Page " + (this.index + 1), this.bounds.centerX(), this.bounds.centerY(), (Paint)this.textPaint);
        this.node.draw(canvas);
        canvas.drawLine(this.bounds.left, this.bounds.top, this.bounds.right, this.bounds.top, this.strokePaint);
        canvas.drawLine(this.bounds.left, this.bounds.bottom, this.bounds.right, this.bounds.bottom, this.strokePaint);
    }

    private Paint strokePaint() {
        Paint strokePaint = new Paint();
        strokePaint.setColor(-16777216);
        strokePaint.setStyle(Paint.Style.STROKE);
        strokePaint.setStrokeWidth(2.0f);
        return strokePaint;
    }

    private Paint fillPaint() {
        Paint fillPaint = new Paint();
        fillPaint.setColor(-7829368);
        fillPaint.setStyle(Paint.Style.FILL);
        return fillPaint;
    }

    private TextPaint textPaint() {
        TextPaint paint = new TextPaint();
        paint.setColor(-16777216);
        paint.setAntiAlias(true);
        paint.setTextSize(24.0f);
        paint.setTextAlign(Paint.Align.CENTER);
        return paint;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(float aspectRatio) {
        if (this.aspectRatio != aspectRatio) {
            this.aspectRatio = aspectRatio;
            this.documentView.invalidatePageSizes();
        }
    }

    public boolean isVisible() {
        return RectF.intersects((RectF)this.documentView.getViewRect(), (RectF)this.bounds);
    }

    public void setAspectRatio(int width, int height) {
        this.setAspectRatio((float)width * 1.0f / (float)height);
    }

    void setBounds(RectF pageBounds) {
        this.bounds = pageBounds;
        this.node.invalidateNodeBounds();
    }

    public void updateVisibility() {
        this.node.updateVisibility();
    }

    public void invalidate() {
        this.node.invalidate();
    }
}

