/*
 * Decompiled with CFR 0.152.
 */
package com.lidong.pdf.util;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.lidong.pdf.api.ApiManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.ResponseBody;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.schedulers.Schedulers;

public class FileUtils {
    private FileUtils() {
    }

    public static File fileFromAsset(Context context, String assetName) throws IOException {
        File outFile = new File(context.getCacheDir(), assetName + "-pdfview.pdf");
        FileUtils.copy(context.getAssets().open(assetName), outFile);
        return outFile;
    }

    public static void fileFromLocalStorage(String fileUrl, final String fileName, final FileListener listener) throws IOException {
        final String SDPath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/pdf/";
        File file = new File(SDPath, fileName);
        if (file.exists()) {
            listener.setFile(file);
        } else {
            ApiManager.downloadPicFromNet(fileUrl).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<ResponseBody>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void call(ResponseBody responseBody) {
                    InputStream is = null;
                    byte[] buf = new byte[2048];
                    int len = 0;
                    FileOutputStream fos = null;
                    try {
                        File fileN;
                        is = responseBody.byteStream();
                        long total = responseBody.contentLength();
                        File file1 = new File(SDPath);
                        if (!file1.exists()) {
                            file1.mkdirs();
                        }
                        if (!(fileN = new File(SDPath, fileName)).exists()) {
                            boolean mkdir = fileN.createNewFile();
                            Log.d((String)"mkdir", (String)("call: " + mkdir));
                        }
                        fos = new FileOutputStream(fileN);
                        long sum = 0L;
                        while ((len = is.read(buf)) != -1) {
                            fos.write(buf, 0, len);
                            int progress = (int)((float)(sum += (long)len) * 1.0f / (float)total * 100.0f);
                            Log.d((String)"h_bl", (String)("progress=" + progress));
                        }
                        fos.flush();
                        Log.d((String)"h_bl", (String)"\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f");
                        listener.setFile(fileN);
                    }
                    catch (Exception e) {
                        Log.d((String)"h_bl", (String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }, (Action1)new Action1<Throwable>(){

                public void call(Throwable throwable) {
                    Log.d((String)"h_bl", (String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, File output) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(output);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, read);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            finally {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
        }
    }

    public static interface FileListener {
        public void setFile(File var1);
    }
}

