/*
 * Decompiled with CFR 0.152.
 */
package com.lidong.pdf;

import android.graphics.RectF;
import com.lidong.pdf.model.PagePart;
import com.lidong.pdf.util.Constants;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Vector;

class CacheManager {
    private PriorityQueue<PagePart> passiveCache;
    private PriorityQueue<PagePart> activeCache = new PriorityQueue<PagePart>(Constants.Cache.CACHE_SIZE, new PagePartComparator());
    private Vector<PagePart> thumbnails;

    public CacheManager() {
        this.passiveCache = new PriorityQueue<PagePart>(Constants.Cache.CACHE_SIZE, new PagePartComparator());
        this.thumbnails = new Vector();
    }

    public void cachePart(PagePart part) {
        this.makeAFreeSpace();
        this.activeCache.offer(part);
    }

    public void makeANewSet() {
        this.passiveCache.addAll(this.activeCache);
        this.activeCache.clear();
    }

    private void makeAFreeSpace() {
        while (this.activeCache.size() + this.passiveCache.size() >= Constants.Cache.CACHE_SIZE && !this.passiveCache.isEmpty()) {
            this.passiveCache.poll().getRenderedBitmap().recycle();
        }
        while (this.activeCache.size() + this.passiveCache.size() >= Constants.Cache.CACHE_SIZE && !this.activeCache.isEmpty()) {
            this.activeCache.poll().getRenderedBitmap().recycle();
        }
    }

    public void cacheThumbnail(PagePart part) {
        if (this.thumbnails.size() >= 4) {
            this.thumbnails.remove(0).getRenderedBitmap().recycle();
        }
        this.thumbnails.add(part);
    }

    public boolean upPartIfContained(int userPage, int page, float width, float height, RectF pageRelativeBounds, int toOrder) {
        PagePart fakePart = new PagePart(userPage, page, null, width, height, pageRelativeBounds, false, 0);
        PagePart found = this.find(this.passiveCache, fakePart);
        if (found != null) {
            this.passiveCache.remove(found);
            found.setCacheOrder(toOrder);
            this.activeCache.offer(found);
            return true;
        }
        return this.find(this.activeCache, fakePart) != null;
    }

    public boolean containsThumbnail(int userPage, int page, float width, float height, RectF pageRelativeBounds) {
        PagePart fakePart = new PagePart(userPage, page, null, width, height, pageRelativeBounds, true, 0);
        for (PagePart part : this.thumbnails) {
            if (!part.equals(fakePart)) continue;
            return true;
        }
        return false;
    }

    private PagePart find(PriorityQueue<PagePart> vector, PagePart fakePart) {
        for (PagePart part : vector) {
            if (!part.equals(fakePart)) continue;
            return part;
        }
        return null;
    }

    public Vector<PagePart> getPageParts() {
        Vector<PagePart> parts = new Vector<PagePart>(this.passiveCache);
        parts.addAll(this.activeCache);
        return parts;
    }

    public Vector<PagePart> getThumbnails() {
        return this.thumbnails;
    }

    public void recycle() {
        for (PagePart part : this.activeCache) {
            part.getRenderedBitmap().recycle();
        }
        for (PagePart part : this.activeCache) {
            part.getRenderedBitmap().recycle();
        }
        for (PagePart part : this.thumbnails) {
            part.getRenderedBitmap().recycle();
        }
        this.passiveCache.clear();
        this.activeCache.clear();
        this.thumbnails.clear();
    }

    class PagePartComparator
    implements Comparator<PagePart> {
        PagePartComparator() {
        }

        @Override
        public int compare(PagePart part1, PagePart part2) {
            if (part1.getCacheOrder() == part2.getCacheOrder()) {
                return 0;
            }
            return part1.getCacheOrder() > part2.getCacheOrder() ? 1 : -1;
        }
    }
}

