/*
 * Decompiled with CFR 0.152.
 */
package org.vudroid.core.multitouch;

import android.view.MotionEvent;
import org.vudroid.core.models.ZoomModel;
import org.vudroid.core.multitouch.MultiTouchZoom;

public class MultiTouchZoomImpl
implements MultiTouchZoom {
    private final ZoomModel zoomModel;
    private boolean resetLastPointAfterZoom;
    private float lastZoomDistance;

    public MultiTouchZoomImpl(ZoomModel zoomModel) {
        this.zoomModel = zoomModel;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if ((ev.getAction() & 5) == 5) {
            this.lastZoomDistance = this.getZoomDistance(ev);
            return true;
        }
        if ((ev.getAction() & 6) == 6) {
            this.lastZoomDistance = 0.0f;
            this.zoomModel.commit();
            this.resetLastPointAfterZoom = true;
            return true;
        }
        if (ev.getAction() == 2 && this.lastZoomDistance != 0.0f) {
            float zoomDistance = this.getZoomDistance(ev);
            this.zoomModel.setZoom(this.zoomModel.getZoom() * zoomDistance / this.lastZoomDistance);
            this.lastZoomDistance = zoomDistance;
            return true;
        }
        return false;
    }

    private float getZoomDistance(MotionEvent ev) {
        return (float)Math.sqrt(Math.pow(ev.getX(0) - ev.getX(1), 2.0) + Math.pow(ev.getY(0) - ev.getY(1), 2.0));
    }

    @Override
    public boolean isResetLastPointAfterZoom() {
        return this.resetLastPointAfterZoom;
    }

    @Override
    public void setResetLastPointAfterZoom(boolean resetLastPointAfterZoom) {
        this.resetLastPointAfterZoom = resetLastPointAfterZoom;
    }
}

