/*
 * Decompiled with CFR 0.152.
 */
package android.serialport;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SerialPort {
    private static final String TAG = "SerialPort";
    public static final String DEFAULT_SU_PATH = "/system/bin/su";
    private static String sSuPath = "/system/bin/su";
    private File device;
    private int baudrate;
    private int dataBits;
    private int parity;
    private int stopBits;
    private int flags;
    private FileDescriptor mFd;
    private FileInputStream mFileInputStream;
    private FileOutputStream mFileOutputStream;

    public static void setSuPath(@Nullable String suPath) {
        if (suPath == null) {
            return;
        }
        sSuPath = suPath;
    }

    @NonNull
    public static String getSuPath() {
        return sSuPath;
    }

    public SerialPort(@NonNull File device, int baudrate, int dataBits, int parity, int stopBits, int flags) throws SecurityException, IOException {
        this.device = device;
        this.baudrate = baudrate;
        this.dataBits = dataBits;
        this.parity = parity;
        this.stopBits = stopBits;
        this.flags = flags;
        if (!device.canRead() || !device.canWrite()) {
            try {
                Process su = Runtime.getRuntime().exec(sSuPath);
                String cmd = "chmod 666 " + device.getAbsolutePath() + "\nexit\n";
                su.getOutputStream().write(cmd.getBytes());
                if (su.waitFor() != 0 || !device.canRead() || !device.canWrite()) {
                    throw new SecurityException();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SecurityException();
            }
        }
        this.mFd = this.open(device.getAbsolutePath(), baudrate, dataBits, parity, stopBits, flags);
        if (this.mFd == null) {
            Log.e((String)TAG, (String)"native open returns null");
            throw new IOException();
        }
        this.mFileInputStream = new FileInputStream(this.mFd);
        this.mFileOutputStream = new FileOutputStream(this.mFd);
    }

    public SerialPort(@NonNull File device, int baudrate) throws SecurityException, IOException {
        this(device, baudrate, 8, 0, 1, 0);
    }

    public SerialPort(@NonNull File device, int baudrate, int dataBits, int parity, int stopBits) throws SecurityException, IOException {
        this(device, baudrate, dataBits, parity, stopBits, 0);
    }

    @NonNull
    public InputStream getInputStream() {
        return this.mFileInputStream;
    }

    @NonNull
    public OutputStream getOutputStream() {
        return this.mFileOutputStream;
    }

    @NonNull
    public File getDevice() {
        return this.device;
    }

    public int getBaudrate() {
        return this.baudrate;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getParity() {
        return this.parity;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getFlags() {
        return this.flags;
    }

    private native FileDescriptor open(String var1, int var2, int var3, int var4, int var5, int var6);

    public native void close();

    public void tryClose() {
        try {
            this.mFileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.mFileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Builder newBuilder(File device, int baudrate) {
        return new Builder(device, baudrate);
    }

    public static Builder newBuilder(String devicePath, int baudrate) {
        return new Builder(devicePath, baudrate);
    }

    static {
        System.loadLibrary("serial_port");
    }

    public static final class Builder {
        private File device;
        private int baudrate;
        private int dataBits = 8;
        private int parity = 0;
        private int stopBits = 1;
        private int flags = 0;

        private Builder(File device, int baudrate) {
            this.device = device;
            this.baudrate = baudrate;
        }

        private Builder(String devicePath, int baudrate) {
            this(new File(devicePath), baudrate);
        }

        public Builder dataBits(int dataBits) {
            this.dataBits = dataBits;
            return this;
        }

        public Builder parity(int parity) {
            this.parity = parity;
            return this;
        }

        public Builder stopBits(int stopBits) {
            this.stopBits = stopBits;
            return this;
        }

        public Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public SerialPort build() throws SecurityException, IOException {
            return new SerialPort(this.device, this.baudrate, this.dataBits, this.parity, this.stopBits, this.flags);
        }
    }
}

