/*
 * Decompiled with CFR 0.152.
 */
package com.liangfeizc.slidepageindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.liangfeizc.slidepageindicator.R;
import java.lang.reflect.Field;

public class CirclePageIndicator
extends LinearLayout
implements ViewPager.OnPageChangeListener {
    public static final int DEFAULT_INDICATOR_SPACING = 5;
    public static final int INDICATOR_TYPE_CIRCLE = 0;
    public static final int INDICATOR_TYPE_FRACTION = 1;
    public static final int DEFAULT_INDICATOR_TYPE = 0;
    private int mActivePosition;
    private int mIndicatorSpacing;
    private int mIndicatorType;
    private ViewPager.OnPageChangeListener mUserDefinedPageChangeListener;

    public CirclePageIndicator(Context context) {
        this(context, null);
    }

    public CirclePageIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CirclePageIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CirclePageIndicator, 0, 0);
        try {
            this.mIndicatorSpacing = a.getDimensionPixelSize(R.styleable.CirclePageIndicator_indicator_spacing, 5);
            this.mIndicatorType = a.getInt(R.styleable.CirclePageIndicator_indicator_type, 0);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    private void init() {
        this.setOrientation(0);
        if (!(this.getLayoutParams() instanceof FrameLayout.LayoutParams)) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            params.gravity = 8388691;
            this.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public void setViewPager(ViewPager pager) {
        this.mUserDefinedPageChangeListener = this.getOnPageChangeListener(pager);
        pager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.addIndicator(pager.getAdapter().getCount());
    }

    private void addIndicator(int count) {
        if (count <= 0) {
            return;
        }
        if (this.mIndicatorType == 0) {
            for (int i = 0; i < count; ++i) {
                ImageView img = new ImageView(this.getContext());
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
                params.leftMargin = this.mIndicatorSpacing;
                params.rightMargin = this.mIndicatorSpacing;
                img.setImageResource(R.drawable.circle_indicator_stroke);
                this.addView((View)img, (ViewGroup.LayoutParams)params);
            }
            ((ImageView)this.getChildAt(0)).setImageResource(R.drawable.circle_indicator_solid);
        } else if (this.mIndicatorType == 1) {
            TextView textView = new TextView(this.getContext());
            textView.setTag((Object)count);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            textView.setText((CharSequence)("1/" + count));
            this.addView((View)textView, (ViewGroup.LayoutParams)params);
        }
    }

    private void updateIndicator(int position) {
        if (this.mActivePosition != position) {
            if (this.mIndicatorType == 0) {
                ((ImageView)this.getChildAt(this.mActivePosition)).setImageResource(R.drawable.circle_indicator_stroke);
                ((ImageView)this.getChildAt(position)).setImageResource(R.drawable.circle_indicator_solid);
            } else if (this.mIndicatorType == 1) {
                TextView textView = (TextView)this.getChildAt(0);
                textView.setText((CharSequence)String.format("%d/%d", position + 1, (int)((Integer)textView.getTag())));
            }
            this.mActivePosition = position;
        }
    }

    private ViewPager.OnPageChangeListener getOnPageChangeListener(ViewPager pager) {
        try {
            Field f = pager.getClass().getDeclaredField("mOnPageChangeListener");
            f.setAccessible(true);
            return (ViewPager.OnPageChangeListener)f.get(pager);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mUserDefinedPageChangeListener != null) {
            this.mUserDefinedPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        this.updateIndicator(position);
        if (this.mUserDefinedPageChangeListener != null) {
            this.mUserDefinedPageChangeListener.onPageSelected(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mUserDefinedPageChangeListener != null) {
            this.mUserDefinedPageChangeListener.onPageScrollStateChanged(state);
        }
    }
}

