/*
 * Decompiled with CFR 0.152.
 */
package com.develop.mnemonic;

import com.develop.mnemonic.MnemonicUtils;
import io.github.novacrypto.bip32.ExtendedPrivateKey;
import io.github.novacrypto.bip32.Network;
import io.github.novacrypto.bip32.networks.Bitcoin;
import io.github.novacrypto.bip44.AddressIndex;
import io.github.novacrypto.bip44.BIP44;

public class KeyPairUtils {
    public static byte[] generatePrivateKey(String mnemonic, int coinType) {
        byte[] seed = MnemonicUtils.generateSeed(mnemonic, "");
        return KeyPairUtils.generatePrivateKey(seed, coinType, (Network)Bitcoin.MAIN_NET);
    }

    public static byte[] generatePrivateKey(byte[] seed, int coinType) {
        return KeyPairUtils.generatePrivateKey(seed, coinType, (Network)Bitcoin.MAIN_NET);
    }

    public static byte[] generatePrivateKey(byte[] seed, int coinType, Network network) {
        AddressIndex addressIndex = BIP44.m().purpose44().coinType(coinType).account(0).external().address(0);
        ExtendedPrivateKey rootKey = ExtendedPrivateKey.fromSeed((byte[])seed, (Network)network);
        ExtendedPrivateKey childPrivateKey = rootKey.derive((Object)addressIndex, AddressIndex.DERIVATION);
        byte[] privateKeyBytes = childPrivateKey.getKey();
        return privateKeyBytes;
    }

    public static class CoinTypes {
        public static final int BTC = 0;
        public static final int BTCTEST = 1;
        public static final int LTC = 2;
        public static final int ETH = 60;
        public static final int EOS = 194;
    }
}

