/*
 * Decompiled with CFR 0.152.
 */
package com.levibostian.teller.repository.manager;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import com.levibostian.teller.Teller;
import com.levibostian.teller.repository.manager.OnlineRepositoryCacheAgeManager;
import com.levibostian.teller.type.Age;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0016J\u001c\u0010\n\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0011\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/levibostian/teller/repository/manager/TellerOnlineRepositoryCacheAgeManager;", "Lcom/levibostian/teller/repository/manager/OnlineRepositoryCacheAgeManager;", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "hasSuccessfullyFetchedCache", "", "tag", "", "Lcom/levibostian/teller/repository/GetCacheRequirementsTag;", "isCacheTooOld", "maxAge", "Lcom/levibostian/teller/type/Age;", "lastSuccessfulFetch", "Ljava/util/Date;", "updateLastSuccessfulFetch", "", "age", "Companion", "teller-android_release"})
public final class TellerOnlineRepositoryCacheAgeManager
implements OnlineRepositoryCacheAgeManager {
    private final SharedPreferences sharedPreferences;
    public static final long INVALID_LAST_FETCHED_VALUE = -1L;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isCacheTooOld(@NotNull String tag, @NotNull Age maxAge) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)maxAge, (String)"maxAge");
        if (!this.hasSuccessfullyFetchedCache(tag)) {
            return true;
        }
        Date date = this.lastSuccessfulFetch(tag);
        if (date == null) {
            Intrinsics.throwNpe();
        }
        return date.compareTo(maxAge.toDate()) < 0;
    }

    @Override
    @SuppressLint(value={"ApplySharedPref"})
    public void updateLastSuccessfulFetch(@NotNull String tag, @NotNull Date age) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)age, (String)"age");
        this.sharedPreferences.edit().putLong(tag, age.getTime()).commit();
    }

    @Override
    public boolean hasSuccessfullyFetchedCache(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        return this.lastSuccessfulFetch(tag) != null;
    }

    @Override
    @Nullable
    public Date lastSuccessfulFetch(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        long lastFetchedTime = this.sharedPreferences.getLong(tag, -1L);
        if (lastFetchedTime <= -1L) {
            return null;
        }
        return new Date(lastFetchedTime);
    }

    public TellerOnlineRepositoryCacheAgeManager(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        this.sharedPreferences = sharedPreferences;
    }

    public /* synthetic */ TellerOnlineRepositoryCacheAgeManager(SharedPreferences sharedPreferences, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            SharedPreferences sharedPreferences2 = Teller.Companion.getShared().getSharedPreferences$teller_android_release();
            if (sharedPreferences2 == null) {
                Intrinsics.throwNpe();
            }
            sharedPreferences = sharedPreferences2;
        }
        this(sharedPreferences);
    }

    public TellerOnlineRepositoryCacheAgeManager() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/levibostian/teller/repository/manager/TellerOnlineRepositoryCacheAgeManager$Companion;", "", "()V", "INVALID_LAST_FETCHED_VALUE", "", "teller-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

