/*
 * Decompiled with CFR 0.152.
 */
package com.leonty;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Selector
implements Comparable<Selector> {
    private String selector;
    private String style;
    private Integer idCount = 0;
    private Integer classCount = 0;
    private Integer elementCount = 0;

    public Selector(String selector, String style) {
        this.selector = selector;
        this.style = style;
        this.calculateSpecificity();
    }

    private void calculateSpecificity() {
        this.uniformSelector();
        Pattern idPattern = Pattern.compile("#[\\w-]+");
        Pattern classPattern = Pattern.compile("\\.[\\w_-]+|\\[\\]");
        Pattern elementPattern = Pattern.compile("(^|\\s)[\\w_-]+");
        this.idCount = this.getMatchCount(idPattern.matcher(this.selector));
        this.classCount = this.getMatchCount(classPattern.matcher(this.selector));
        this.elementCount = this.getMatchCount(elementPattern.matcher(this.selector));
    }

    private void uniformSelector() {
        this.selector = this.selector.replaceAll("\\*", "");
        this.selector = this.selector.replaceAll("\"[^\"]\\*\"", "");
        this.selector = this.selector.replaceAll("'[^']\\*'", "");
        this.selector = this.selector.replaceAll("\\[[^\\]]*\\]", "[]");
        this.selector = this.selector.replaceAll("[>+~]+", " ");
        Pattern functionPattern = Pattern.compile("\\([^)]*\\)");
        Matcher functionMatcher = functionPattern.matcher(this.selector);
        while (functionMatcher.find()) {
            this.selector = functionMatcher.replaceAll("");
        }
        this.selector = this.selector.replaceAll(":(first-child|first-letter|last-child|link|visited|hover|active|focus|lang)", ".pseudo");
        this.selector = this.selector.replaceAll(":[\\w-]+", " pseudo");
    }

    private int getMatchCount(Matcher matcher) {
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public Integer getIdCount() {
        return this.idCount;
    }

    public Integer getClassCount() {
        return this.classCount;
    }

    public Integer getElementCount() {
        return this.elementCount;
    }

    public String getStyle() {
        return this.style;
    }

    public String toString() {
        return this.idCount + " " + this.classCount + " " + this.elementCount;
    }

    @Override
    public int compareTo(Selector that) {
        if (this.getIdCount() != that.getIdCount()) {
            return this.getIdCount().compareTo(that.getIdCount());
        }
        if (this.getClassCount() != that.getClassCount()) {
            return this.getClassCount().compareTo(that.getClassCount());
        }
        if (this.getElementCount() != that.getElementCount()) {
            return this.getElementCount().compareTo(that.getElementCount());
        }
        return 0;
    }
}

