/*
 * Decompiled with CFR 0.152.
 */
package com.leonty;

import com.leonty.Selector;
import com.leonty.Try;
import com.osbcp.cssparser.CSSParser;
import com.osbcp.cssparser.PropertyValue;
import com.osbcp.cssparser.Rule;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.jsoup.select.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSInliner {
    private static final Logger LOG = LoggerFactory.getLogger(CSSInliner.class);
    private static final Pattern url1 = Pattern.compile("url\\([ ]*'([^']+)'[ ]*\\)");
    private static final Pattern url2 = Pattern.compile("url\\([ ]*\"([^\"]+)\"[ ]*\\)");

    public static String inlineCss(String html, String css) throws Exception {
        return CSSInliner.inlineCss(html, css, false);
    }

    public static String cleanup(String html) {
        Document doc = Jsoup.parse((String)html);
        return doc.html();
    }

    public static String inlineCss(String html, String css, Boolean removeAttributes) throws Exception {
        Document doc = Jsoup.parse((String)html);
        HashMap<Element, ArrayList<Selector>> selected = new HashMap<Element, ArrayList<Selector>>();
        css = css + CSSInliner.getInternalStyles(doc);
        CSSInliner.extractSelectors(css, doc, selected);
        CSSInliner.mergeCss(removeAttributes, selected);
        return doc.html();
    }

    public static String inlineCss(String html, Boolean removeAttributes) throws Exception {
        Document doc = Jsoup.parse((String)html);
        HashMap<Element, ArrayList<Selector>> selected = new HashMap<Element, ArrayList<Selector>>();
        String css = CSSInliner.readExternalStyles(doc);
        CSSInliner.remvoeExternalStyles(doc);
        css = css + CSSInliner.getInternalStyles(doc);
        CSSInliner.extractSelectors(css, doc, selected);
        CSSInliner.mergeCss(removeAttributes, selected);
        return doc.html();
    }

    public static String internalCss(String html) throws IOException {
        Document doc = Jsoup.parse((String)html);
        String css = CSSInliner.readExternalStyles(doc);
        css = css + CSSInliner.getInternalStyles(doc);
        CSSInliner.remvoeExternalStyles(doc);
        Element head = doc.head();
        head.append("<style type=\"text/css\">\n" + css + "\n</style>");
        return doc.html();
    }

    private static void mergeCss(Boolean removeAttributes, HashMap<Element, ArrayList<Selector>> selected) {
        for (Map.Entry<Element, ArrayList<Selector>> pair : selected.entrySet()) {
            Collections.sort((List)pair.getValue());
            String style = "";
            for (Selector selector : pair.getValue()) {
                style = style + selector.getStyle();
            }
            String initialStyle = pair.getKey().attr("style");
            if (initialStyle != null && !initialStyle.isEmpty()) {
                style = style + initialStyle;
            }
            pair.getKey().attr("style", style);
            if (!removeAttributes.booleanValue()) continue;
            pair.getKey().removeAttr("class");
        }
    }

    private static void extractSelectors(String css, Document doc, HashMap<Element, ArrayList<Selector>> selected) throws Exception {
        CSSInliner.extractSelectors(css, doc, selected, false);
    }

    private static void extractSelectors(String css, Document doc, HashMap<Element, ArrayList<Selector>> selected, boolean debug) throws Exception {
        LOG.trace("extract selectors from [{}]", (Object)css);
        List rules = CSSParser.parse((String)css);
        ArrayList<com.osbcp.cssparser.Selector> ignored = new ArrayList<com.osbcp.cssparser.Selector>();
        for (Rule rule : rules) {
            for (com.osbcp.cssparser.Selector selector : rule.getSelectors()) {
                Try<Elements> validSelector = CSSInliner.select(doc, selector.toString());
                if (validSelector.isDefined()) {
                    Elements elements = validSelector.get();
                    for (Element element : elements) {
                        ArrayList<Selector> selectors = new ArrayList<Selector>();
                        if (selected.containsKey(element)) {
                            selectors = selected.get(element);
                        }
                        selectors.add(new Selector(selector.toString(), CSSInliner.getStyleString(rule)));
                        selected.put(element, selectors);
                    }
                    continue;
                }
                ignored.add(selector);
                if (!debug) continue;
                LOG.warn("Couldn't select with [" + selector.toString() + "]", validSelector.failure());
            }
        }
        LOG.warn("{} selectors where ignored while {} where returned. Switch to trace to get a list.", (Object)ignored.size(), (Object)selected.size());
        LOG.trace("The following selectors where ignored {}", ignored);
    }

    private static Try<Elements> select(Document doc, String selector) {
        try {
            return Try.success(doc.select(selector));
        }
        catch (Selector.SelectorParseException e) {
            return Try.failure(e);
        }
    }

    private static String readExternalStyles(Document doc) throws IOException {
        Elements elements = CSSInliner.selectExternalStyle(doc);
        StringBuilder styles = new StringBuilder();
        for (Element style : elements) {
            String url = style.attr("href");
            LOG.info("Download external css from [{}]", (Object)url);
            String cssContent = Jsoup.connect((String)url).execute().body();
            cssContent = CSSInliner.replaceRelativeUrls(cssContent, url);
            styles.append("/*external css from [").append(url).append("]*/\n").append(cssContent).append("\n");
        }
        return styles.toString();
    }

    private static String replaceRelativeUrls(String cssContent, String url) {
        String result = cssContent;
        result = CSSInliner.replaceUrlWithSeparator(result, url, "'", url1);
        result = CSSInliner.replaceUrlWithSeparator(result, url, "\"", url2);
        return result;
    }

    private static String replaceUrlWithSeparator(String cssContent, String url, String separator, Pattern urlMatcher) {
        try {
            URI parent;
            String result = cssContent;
            Matcher m = urlMatcher.matcher(result);
            StringBuffer sb = new StringBuffer();
            URI fullURL = new URI(url);
            URI uRI = parent = fullURL.getPath().endsWith("/") ? fullURL.resolve("..") : fullURL.resolve(".");
            while (m.find()) {
                String foundUrl = m.group(1);
                String replacement = "";
                replacement = CSSInliner.isAbsoluteURL(foundUrl) ? foundUrl : parent.toString() + foundUrl;
                m.appendReplacement(sb, "url(" + separator + replacement + separator + ")");
            }
            m.appendTail(sb);
            result = sb.toString();
            result = url2.matcher(result).replaceAll("url(\"$1\")");
            return result;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isAbsoluteURL(String url) {
        try {
            URL baseHTTP = new URL("http://example.com");
            URL baseFILE = new URL("file:///");
            URL frelative = new URL(baseFILE, url);
            URL hrelative = new URL(baseHTTP, url);
            return frelative.equals(hrelative);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isAbsoluteURL2(String url) {
        try {
            URI u = new URI(url);
            return u.isAbsolute();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void remvoeExternalStyles(Document doc) {
        Elements elements = CSSInliner.selectExternalStyle(doc);
        elements.remove();
    }

    private static Elements selectExternalStyle(Document doc) {
        return doc.select("link[rel=stylesheet],link[type=text/css]");
    }

    public static String getInternalStyles(Document doc) throws IOException {
        Elements elements = doc.select("style");
        String styles = "";
        for (Element style : elements) {
            styles = styles + style.html();
        }
        elements.remove();
        return styles;
    }

    public static String getStyleString(Rule rule) {
        String style = "";
        for (PropertyValue propertyValue : rule.getPropertyValues()) {
            style = style + propertyValue.getProperty() + ": " + propertyValue.getValue() + "; ";
        }
        return style;
    }
}

