/*
 * Decompiled with CFR 0.152.
 */
package com.leinardi.android.speeddial;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.res.ResourcesCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.RelativeLayout;
import com.leinardi.android.speeddial.R;
import com.leinardi.android.speeddial.UiUtils;

public class SpeedDialOverlayLayout
extends RelativeLayout {
    private static final String TAG = SpeedDialOverlayLayout.class.getSimpleName();
    private boolean mClickableOverlay;
    private int mAnimationDuration;
    @Nullable
    private View.OnClickListener mClickListener;

    public SpeedDialOverlayLayout(@NonNull Context context) {
        super(context);
    }

    public SpeedDialOverlayLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SpeedDialOverlayLayout(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public boolean hasClickableOverlay() {
        return this.mClickableOverlay;
    }

    public void setClickableOverlay(boolean clickableOverlay) {
        this.mClickableOverlay = clickableOverlay;
        this.setOnClickListener(this.mClickListener);
    }

    public void setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean animate) {
        if (animate) {
            UiUtils.fadeInAnim((View)this);
        } else {
            this.setVisibility(0);
        }
    }

    public void hide() {
        this.hide(true);
    }

    public void hide(boolean animate) {
        if (animate) {
            UiUtils.fadeOutAnim((View)this);
        } else {
            this.setVisibility(8);
        }
    }

    public void setOnClickListener(@Nullable View.OnClickListener clickListener) {
        this.mClickListener = clickListener;
        super.setOnClickListener((View.OnClickListener)(this.hasClickableOverlay() ? clickListener : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray attr2 = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SpeedDialOverlayLayout, 0, 0);
        int overlayColor = ResourcesCompat.getColor((Resources)this.getResources(), (int)R.color.sd_overlay_color, (Resources.Theme)context.getTheme());
        try {
            overlayColor = attr2.getColor(R.styleable.SpeedDialOverlayLayout_android_background, overlayColor);
            this.mClickableOverlay = attr2.getBoolean(R.styleable.SpeedDialOverlayLayout_clickable_overlay, true);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failure setting FabOverlayLayout attrs", (Throwable)e);
        }
        finally {
            attr2.recycle();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.setElevation(this.getResources().getDimension(R.dimen.sd_overlay_elevation));
        }
        this.setBackgroundColor(overlayColor);
        this.setVisibility(8);
        this.mAnimationDuration = this.getResources().getInteger(17694722);
    }
}

