/*
 * Decompiled with CFR 0.152.
 */
package com.leia.android.lights;

import android.content.Context;
import android.util.Log;
import com.leia.android.lights.ColorProfile;
import com.leia.android.lights.ColorProfileUtil;
import com.leia.android.lights.DisplayConfig;
import com.leia.android.lights.ExceptionUtils;
import com.leia.android.lights.LeiaLightsManager;
import com.leiainc.androidsdk.display.BacklightEventListener;
import com.leiainc.androidsdk.display.LeiaDisplayManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class LeiaDisplayManagerV2Impl
implements LeiaDisplayManager {
    private static final String TAG = "DisplayManagerV2Impl";
    private LeiaLightsManager mLeiaLightsManager;
    private Set<BacklightEventListener> mBacklightEventListeners = new HashSet<BacklightEventListener>();

    LeiaDisplayManagerV2Impl(LeiaLightsManager leiaLightsManager) {
        this.mLeiaLightsManager = leiaLightsManager;
    }

    private Map<String, Method> getMethods() {
        Method[] methods;
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        for (Method method : methods = LeiaLightsManager.class.getDeclaredMethods()) {
            methodMap.put(method.getName(), method);
        }
        return methodMap;
    }

    @Override
    public String getPlatformVersion() {
        return "2.0";
    }

    @Override
    public LeiaDisplayManager.BacklightMode getBacklightMode() {
        if (this.getPlatformVersion().equals("2.0")) {
            Log.d((String)TAG, (String)"Invoking getBacklightMode() on legacy platform.");
            Method getBacklightMode = this.getMethods().get("getBacklightMode");
            if (getBacklightMode.getGenericParameterTypes().length != 0) {
                throw new IllegalArgumentException("Unexpected method parameters.");
            }
            try {
                int result = (Integer)getBacklightMode.invoke((Object)this.mLeiaLightsManager, new Object[0]);
                switch (result) {
                    case 2: {
                        return LeiaDisplayManager.BacklightMode.MODE_2D;
                    }
                    case 3: {
                        return LeiaDisplayManager.BacklightMode.MODE_3D;
                    }
                }
                throw ExceptionUtils.createUnexpectedBacklightException(Integer.toString(result));
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        LeiaLightsManager.BacklightMode mode = this.mLeiaLightsManager.getBacklightMode();
        switch (mode) {
            case MODE_3D: {
                return LeiaDisplayManager.BacklightMode.MODE_3D;
            }
            case MODE_2D: {
                return LeiaDisplayManager.BacklightMode.MODE_2D;
            }
        }
        throw ExceptionUtils.createIllegalBacklightArgumentException();
    }

    private ViewConfig getViewConfig() {
        Log.d((String)TAG, (String)"Invoking getViewConfig() on legacy platform.");
        return new ViewConfig(2560, 1440, 4, 4);
    }

    private int getOffset(Orientation orientation) {
        int[] xyCalibration;
        Log.d((String)TAG, (String)"Invoking getOffset() on legacy platform.");
        Method getXYCalibration = this.getMethods().get("getXYCalibration");
        if (getXYCalibration.getGenericParameterTypes().length != 0) {
            throw new IllegalArgumentException("Unexpected method parameters.");
        }
        try {
            xyCalibration = (int[])getXYCalibration.invoke((Object)this.mLeiaLightsManager, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (xyCalibration.length != 3) {
            throw new RuntimeException();
        }
        switch (orientation) {
            case PORTRAIT: {
                return xyCalibration[1];
            }
            case LANDSCAPE: {
                return xyCalibration[2];
            }
        }
        throw ExceptionUtils.createIllegalOrientationException();
    }

    private float[] getACT(Orientation orientation) {
        Log.d((String)TAG, (String)"Invoking getACT() on legacy platform.");
        switch (orientation) {
            case PORTRAIT: {
                return new float[]{0.09f, 0.035f};
            }
            case LANDSCAPE: {
                return new float[]{0.002f, 0.003f};
            }
        }
        throw ExceptionUtils.createIllegalOrientationException();
    }

    private int getSystemDisparity() {
        Log.d((String)TAG, (String)"Invoking getSystemDisparity() on legacy platform.");
        Method getSystemScaling = this.getMethods().get("getSystemScaling");
        if (getSystemScaling == null) {
            return 8;
        }
        if (getSystemScaling.getGenericParameterTypes().length != 0) {
            throw new IllegalArgumentException("Unexpected method parameters.");
        }
        try {
            return (Integer)getSystemScaling.invoke((Object)this.mLeiaLightsManager, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DisplayConfig getDisplayConfig() {
        DisplayConfig displayConfig = new DisplayConfig();
        ViewConfig viewConfig = this.getViewConfig();
        int systemDisparity = this.getSystemDisparity();
        int xOffset = this.getOffset(Orientation.PORTRAIT);
        int yOffset = this.getOffset(Orientation.LANDSCAPE);
        float[] xAct = this.getACT(Orientation.PORTRAIT);
        float[] yAct = this.getACT(Orientation.LANDSCAPE);
        displayConfig.mPanelResolution = new DisplayConfig.XyPair<Integer>(viewConfig.resolution.y, viewConfig.resolution.x);
        displayConfig.mAlignmentOffset = new DisplayConfig.XyPair<Float>(Float.valueOf(yOffset), Float.valueOf(xOffset));
        displayConfig.mViewSharpeningCoefficients = new DisplayConfig.XyPair<List<Float>>(Arrays.asList(Float.valueOf(yAct[0]), Float.valueOf(yAct[1])), Arrays.asList(Float.valueOf(xAct[0]), Float.valueOf(xAct[1])));
        displayConfig.mSystemDisparity = systemDisparity;
        displayConfig.mNumViews = new DisplayConfig.XyPair<Integer>(viewConfig.numberOfViews.y, viewConfig.numberOfViews.x);
        displayConfig.mDotPitchInMm = new DisplayConfig.XyPair<Float>(Float.valueOf(0.049305554f), Float.valueOf(0.04921875f));
        return displayConfig;
    }

    public float[] getBacklightRatios(LeiaDisplayManager.BacklightMode mode) {
        float ratio3d;
        float ratio2d;
        Log.d((String)TAG, (String)"Invoking getBacklightRatios() on legacy platform.");
        if (mode != this.getBacklightMode()) {
            switch (mode) {
                case MODE_2D: {
                    return new float[]{1.0f, 0.1f};
                }
                case MODE_3D: {
                    return new float[]{0.0f, 1.0f};
                }
            }
            throw ExceptionUtils.createIllegalBacklightArgumentException();
        }
        Method getRatio2d = this.getMethods().get("getRatio2d");
        if (getRatio2d.getGenericParameterTypes().length != 0) {
            throw new IllegalArgumentException("Unexpected method parameters.");
        }
        try {
            ratio2d = ((Float)getRatio2d.invoke((Object)this.mLeiaLightsManager, new Object[0])).floatValue();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        Method getRatio3d = this.getMethods().get("getRatio3d");
        if (getRatio3d.getGenericParameterTypes().length != 0) {
            throw new IllegalArgumentException("Unexpected method parameters.");
        }
        try {
            ratio3d = ((Float)getRatio3d.invoke((Object)this.mLeiaLightsManager, new Object[0])).floatValue();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return new float[]{ratio2d, ratio3d};
    }

    public void setBacklightRatios(LeiaDisplayManager.BacklightMode mode, float ratio2d, float ratio3d) {
        int otherMode;
        Log.d((String)TAG, (String)"Invoking setBacklightRatios() on legacy platform.");
        Method setBacklightSettings = this.getMethods().get("setBacklightSettings");
        switch (mode) {
            case MODE_2D: {
                otherMode = 2;
                break;
            }
            case MODE_3D: {
                otherMode = 3;
                break;
            }
            default: {
                throw ExceptionUtils.createIllegalBacklightArgumentException();
            }
        }
        try {
            setBacklightSettings.invoke((Object)this.mLeiaLightsManager, otherMode, Float.valueOf(ratio2d), Float.valueOf(ratio3d));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void setColorProfile(LeiaDisplayManager.BacklightMode mode, ColorProfile colorProfile, Context context) {
        ColorProfileUtil.setColorProfile(mode, colorProfile, context);
    }

    public void restoreDefaults() {
        Log.w((String)TAG, (String)"restoreDefaults() unimplemented on this platform.");
    }

    public void setAlignmentOffset(float xOffset, float yOffset) {
        Log.w((String)TAG, (String)"setOffset() unimplemented on this platform.");
    }

    public void setViewSharpeningCoefficients(float xa, float xb, float ya, float yb) {
        Log.w((String)TAG, (String)"setACT() unimplemented on this platform.");
    }

    public void setSystemDisparity(int d) {
        Log.w((String)TAG, (String)"setSystemDisparity() unimplemented on this platform.");
    }

    public void setBacklightTransition(float ratio2d, float ratio3d) {
        Log.w((String)TAG, (String)"setBacklightTransition() unimplemented on this platform.");
    }

    public void setBrightnessLevel(int brightnessLevel) {
        Log.d((String)TAG, (String)"Invoking setBrightnessLevel() on legacy platform.");
        Method setBrightnessLevel = this.getMethods().get("setBrightnessLevel");
        if (setBrightnessLevel.getGenericParameterTypes().length != 1 || setBrightnessLevel.getGenericParameterTypes()[0] != Integer.TYPE) {
            throw new IllegalArgumentException("Unexpected method parameters.");
        }
        try {
            setBrightnessLevel.invoke((Object)this.mLeiaLightsManager, brightnessLevel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setBacklightMode(LeiaDisplayManager.BacklightMode backlightMode) {
        this.requestBacklightMode(backlightMode);
    }

    @Override
    public void requestBacklightMode(LeiaDisplayManager.BacklightMode backlightMode) {
        int legacyIntParameter;
        if (this.getBacklightMode() == backlightMode) {
            return;
        }
        Log.d((String)TAG, (String)"Invoking requestBacklightMode() on legacy platform.");
        for (BacklightEventListener listener : this.mBacklightEventListeners) {
            listener.onBacklightModeChanged(backlightMode);
        }
        Method setBacklightMode = this.getMethods().get("setBacklightMode");
        if (setBacklightMode.getGenericParameterTypes().length != 1 || setBacklightMode.getGenericParameterTypes()[0] != Integer.TYPE) {
            throw new IllegalStateException("Unexpected method parameters.");
        }
        switch (backlightMode) {
            case MODE_2D: {
                legacyIntParameter = 2;
                break;
            }
            case MODE_3D: {
                legacyIntParameter = 3;
                break;
            }
            default: {
                return;
            }
        }
        try {
            setBacklightMode.invoke((Object)this.mLeiaLightsManager, legacyIntParameter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registerBacklightEventListener(BacklightEventListener backlightEventListener) {
        this.mBacklightEventListeners.add(backlightEventListener);
    }

    @Override
    public void deregisterBacklightEventListener(BacklightEventListener backlightEventListener) {
        this.mBacklightEventListeners.remove(backlightEventListener);
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onWindowFocusedChanged(boolean hasFocus) {
    }

    static enum Orientation {
        LANDSCAPE,
        PORTRAIT;

    }

    static class ViewConfig {
        Resolution resolution;
        NumberOfViews numberOfViews;

        ViewConfig(int resX, int resY, int viewX, int viewY) {
            this.resolution = new Resolution(resX, resY);
            this.numberOfViews = new NumberOfViews(viewX, viewY);
        }

        public String toString() {
            return "ViewConfig{resolution=" + this.resolution + ", numberOfViews=" + this.numberOfViews + '}';
        }

        static class NumberOfViews {
            int x;
            int y;

            NumberOfViews(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public String toString() {
                return "NumberOfViews{x=" + this.x + ", y=" + this.y + '}';
            }
        }

        static class Resolution {
            int x;
            int y;

            Resolution(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public String toString() {
                return "Resolution{x=" + this.x + ", y=" + this.y + '}';
            }
        }
    }
}

