/*
 * Decompiled with CFR 0.152.
 */
package com.leia.android.lights;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Settings;
import com.leia.android.lights.ColorProfile;
import com.leiainc.androidsdk.display.LeiaDisplayManagerSource;

class ColorProfileUtil {
    private ColorProfileUtil() {
    }

    static void setColorProfile(LeiaDisplayManagerSource.BacklightMode mode, ColorProfile colorProfile, Context context) {
        if (!Settings.System.canWrite((Context)context)) {
            Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + context.getPackageName())));
            context.startActivity(intent);
            return;
        }
        if (mode == LeiaDisplayManagerSource.BacklightMode.MODE_2D) {
            ColorProfileUtil.set2DColorProfile(context, colorProfile);
        } else if (mode == LeiaDisplayManagerSource.BacklightMode.MODE_3D) {
            ColorProfileUtil.set3DColorProfile(context, colorProfile);
        } else {
            throw new IllegalArgumentException("Unexpected backlight mode " + (Object)((Object)mode));
        }
    }

    private static void set2DColorProfile(Context context, ColorProfile colorProfile) {
        ContentResolver resolver = context.getContentResolver();
        Settings.System.putInt((ContentResolver)resolver, (String)"backlight_colormode_2d", (int)colorProfile.mSystemCode);
    }

    private static void set3DColorProfile(Context context, ColorProfile colorProfile) {
        ContentResolver resolver = context.getContentResolver();
        Settings.System.putInt((ContentResolver)resolver, (String)"backlight_colormode_3d", (int)colorProfile.mSystemCode);
    }
}

