/*
 * Decompiled with CFR 0.152.
 */
package com.leiainc.androidsdk.display;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import com.leia.android.lights.DisplayConfig;
import com.leiainc.androidsdk.display.LeiaDisplayManagerSource;
import com.leiainc.androidsdk.display.LeiaSDK;
import java.util.List;

public class SimpleDisplayQuery {
    private final LeiaDisplayManagerSource mDisplayManager;
    private final boolean mIsPortraitNativeOrientation;

    public SimpleDisplayQuery(Context context) {
        this.mDisplayManager = LeiaSDK.getDisplayManager(context);
        this.mIsPortraitNativeOrientation = this.isPortraitNativeOrientation();
    }

    public float[] getViewSharpening() {
        return this.getViewSharpening(this.isCurrentlyInPortraitOrientation());
    }

    public float[] getViewSharpening(boolean is_portrait) {
        if (this.mDisplayManager == null) {
            return new float[]{0.0f, 0.0f};
        }
        DisplayConfig c = this.mDisplayManager.getDisplayConfig();
        List coefficients = this.doesCurrentOrientationMatchNativeOrientation(is_portrait) ? (List)c.getViewSharpeningCoefficients().x : (List)c.getViewSharpeningCoefficients().y;
        int size = coefficients.size();
        float[] params = new float[size];
        for (int i = 0; i < size; ++i) {
            params[i] = ((Float)coefficients.get(i)).floatValue();
        }
        return params;
    }

    public float getAlignmentOffset() {
        return this.getAlignmentOffset(this.isCurrentlyInPortraitOrientation());
    }

    public float getAlignmentOffset(boolean is_portrait) {
        if (this.mDisplayManager == null) {
            return 0.0f;
        }
        DisplayConfig c = this.mDisplayManager.getDisplayConfig();
        if (this.doesCurrentOrientationMatchNativeOrientation(is_portrait)) {
            return ((Float)c.getAlignmentOffset().x).floatValue();
        }
        return ((Float)c.getAlignmentOffset().y).floatValue();
    }

    public int getSystemDisparity() {
        if (this.mDisplayManager == null) {
            return 0;
        }
        DisplayConfig c = this.mDisplayManager.getDisplayConfig();
        return c.getSystemDisparity();
    }

    public int[] getScreenResolution() {
        return this.getScreenResolution(this.isCurrentlyInPortraitOrientation());
    }

    public int[] getScreenResolution(boolean is_portrait) {
        int[] resolution = new int[]{0, 0};
        if (this.mDisplayManager == null) {
            return resolution;
        }
        DisplayConfig c = this.mDisplayManager.getDisplayConfig();
        if (this.doesCurrentOrientationMatchNativeOrientation(is_portrait)) {
            resolution[0] = (Integer)c.getPanelResolution().x;
            resolution[1] = (Integer)c.getPanelResolution().y;
        } else {
            resolution[1] = (Integer)c.getPanelResolution().x;
            resolution[0] = (Integer)c.getPanelResolution().y;
        }
        return resolution;
    }

    public int[] getNumAvailableViews() {
        return this.getNumAvailableViews(this.isCurrentlyInPortraitOrientation());
    }

    public int[] getNumAvailableViews(boolean is_portrait) {
        int[] dims = new int[]{0, 0};
        if (this.mDisplayManager == null) {
            return dims;
        }
        DisplayConfig c = this.mDisplayManager.getDisplayConfig();
        if (this.doesCurrentOrientationMatchNativeOrientation(is_portrait)) {
            dims[0] = (Integer)c.getNumViews().x;
            dims[1] = (Integer)c.getNumViews().y;
        } else {
            dims[1] = (Integer)c.getNumViews().x;
            dims[0] = (Integer)c.getNumViews().y;
        }
        return dims;
    }

    public int[] getViewResolution() {
        return this.getViewResolution(this.isCurrentlyInPortraitOrientation());
    }

    public int[] getViewResolution(boolean is_portrait) {
        int[] dims_view = new int[]{0, 0};
        if (this.mDisplayManager == null) {
            return dims_view;
        }
        DisplayConfig c = this.mDisplayManager.getDisplayConfig();
        if (this.doesCurrentOrientationMatchNativeOrientation(is_portrait)) {
            dims_view[0] = (Integer)c.getViewResolution().x;
            dims_view[1] = (Integer)c.getViewResolution().y;
        } else {
            dims_view[1] = (Integer)c.getViewResolution().x;
            dims_view[0] = (Integer)c.getViewResolution().y;
        }
        return dims_view;
    }

    public boolean doesCurrentOrientationMatchNativeOrientation(boolean is_portrait) {
        return is_portrait == this.mIsPortraitNativeOrientation;
    }

    public boolean isPortraitNativeOrientation() {
        boolean is_portrait_native_orientation = false;
        if (this.mDisplayManager != null) {
            DisplayConfig c = this.mDisplayManager.getDisplayConfig();
            DisplayConfig.XyPair<Integer> screen_resolution = c.getPanelResolution();
            if ((Integer)screen_resolution.x < (Integer)screen_resolution.y) {
                is_portrait_native_orientation = true;
            }
        }
        return is_portrait_native_orientation;
    }

    public boolean isCurrentlyInPortraitOrientation() {
        DisplayMetrics dm = Resources.getSystem().getDisplayMetrics();
        int height = dm.heightPixels;
        int width = dm.widthPixels;
        return height > width;
    }
}

