/*
 * Decompiled with CFR 0.152.
 */
package com.leia.android.lights;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Nullable;
import com.leia.android.lights.DisplayConfig;
import com.leia.android.lights.LeiaDisplayManagerV2Impl;
import com.leia.android.lights.LeiaDisplayManagerV3Impl;
import com.leia.android.lights.LeiaDisplayManagerV4Impl;
import com.leia.android.lights.LeiaDisplayManagerV5Impl;
import com.leia.android.lights.LeiaDisplayManagerV6Impl;
import com.leia.android.lights.LeiaDisplayManagerV7Impl;
import com.leia.android.lights.LeiaLightsManager;
import com.leia.android.lights.LeiaLightsManagerV4;
import com.leia.android.lights.LeiaLightsManagerV5;
import com.leia.android.lights.LeiaLightsManagerV6;
import com.leia.android.lights.LeiaLightsManagerV7;
import com.leiainc.androidsdk.display.LeiaDisplayManagerSource;
import java.lang.reflect.Method;

public class LeiaSDKImpl {
    private static final String TAG = "LeiaSDK";
    private static LeiaDisplayManagerSource sLeiaDisplayManager;

    protected LeiaSDKImpl() {
    }

    private static LeiaDisplayManagerSource getV2DisplayManager(Context context) {
        try {
            String platformVersion = LeiaSDKImpl.getPlatformVersion();
            if (!"2.0".equals(platformVersion)) {
                return null;
            }
            LeiaDisplayManagerV2Impl displayManager = new LeiaDisplayManagerV2Impl(new LeiaLightsManager(context));
            LeiaSDKImpl.sanityCheckApis(displayManager);
            return displayManager;
        }
        catch (RuntimeException e) {
            Log.i((String)TAG, (String)" V2 platform APIs not available.");
            return null;
        }
    }

    private static LeiaDisplayManagerSource getV3DisplayManager(Context context) {
        try {
            String platformVersion = LeiaSDKImpl.getPlatformVersion();
            if (!"3.0".equals(platformVersion)) {
                return null;
            }
            LeiaDisplayManagerV3Impl displayManager = new LeiaDisplayManagerV3Impl(new LeiaLightsManager(context));
            LeiaSDKImpl.sanityCheckApis(displayManager);
            return displayManager;
        }
        catch (RuntimeException e) {
            Log.i((String)TAG, (String)"V3 platform APIs not available.");
            return null;
        }
    }

    private static LeiaDisplayManagerSource getV4DisplayManager(Context context) {
        try {
            LeiaLightsManagerV4 leiaLightsManager = new LeiaLightsManagerV4(context);
            LeiaDisplayManagerV4Impl displayManager = new LeiaDisplayManagerV4Impl(leiaLightsManager);
            LeiaSDKImpl.sanityCheckApis(displayManager);
            return displayManager;
        }
        catch (RuntimeException e) {
            Log.i((String)TAG, (String)"V4 platform APIs not available.");
            return null;
        }
    }

    private static LeiaDisplayManagerSource getV5DisplayManager(Context context) {
        try {
            LeiaLightsManagerV5 leiaLightsManager = new LeiaLightsManagerV5(context);
            LeiaDisplayManagerV5Impl displayManager = new LeiaDisplayManagerV5Impl(context, leiaLightsManager);
            LeiaSDKImpl.sanityCheckApis(displayManager);
            return displayManager;
        }
        catch (RuntimeException e) {
            Log.i((String)TAG, (String)"V5 platform APIs not available.");
            return null;
        }
    }

    private static LeiaDisplayManagerSource getV6DisplayManager(Context context) {
        try {
            LeiaLightsManagerV6 leiaLightsManager = new LeiaLightsManagerV6(context);
            LeiaDisplayManagerV6Impl displayManager = new LeiaDisplayManagerV6Impl(context, leiaLightsManager);
            LeiaSDKImpl.sanityCheckApis(displayManager);
            return displayManager;
        }
        catch (RuntimeException e) {
            Log.i((String)TAG, (String)"V6 platform APIs not available.");
            return null;
        }
    }

    private static LeiaDisplayManagerSource getV7DisplayManager(Context context) {
        try {
            LeiaLightsManagerV7 leiaLightsManager = new LeiaLightsManagerV7(context);
            LeiaDisplayManagerV7Impl displayManager = new LeiaDisplayManagerV7Impl(context, leiaLightsManager);
            LeiaSDKImpl.sanityCheckApis(displayManager);
            return displayManager;
        }
        catch (RuntimeException e) {
            Log.i((String)TAG, (String)"V6 platform APIs not available.");
            return null;
        }
    }

    private static void sanityCheckApis(LeiaDisplayManagerSource displayManager) {
        try {
            Log.i((String)TAG, (String)("Platform version " + displayManager.getPlatformVersion()));
            LeiaDisplayManagerSource.BacklightMode backlightMode = displayManager.getBacklightMode();
            Log.i((String)TAG, (String)("backlightMode " + backlightMode.name()));
            DisplayConfig displayConfig = displayManager.getDisplayConfig();
            Log.i((String)TAG, (String)("displayConfig " + displayConfig));
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Sanity check failed. Backend is incompatible. v7.0.17", (Throwable)e);
        }
    }

    @Nullable
    public static LeiaDisplayManagerSource getDisplayManager(Context context) {
        if (sLeiaDisplayManager != null) {
            return sLeiaDisplayManager;
        }
        Context appContext = context.getApplicationContext();
        Log.i((String)TAG, (String)"Display SDK 7.0.17");
        sLeiaDisplayManager = LeiaSDKImpl.getV7DisplayManager(appContext);
        if (sLeiaDisplayManager != null) {
            return sLeiaDisplayManager;
        }
        sLeiaDisplayManager = LeiaSDKImpl.getV6DisplayManager(appContext);
        if (sLeiaDisplayManager != null) {
            return sLeiaDisplayManager;
        }
        sLeiaDisplayManager = LeiaSDKImpl.getV5DisplayManager(appContext);
        if (sLeiaDisplayManager != null) {
            return sLeiaDisplayManager;
        }
        sLeiaDisplayManager = LeiaSDKImpl.getV4DisplayManager(appContext);
        if (sLeiaDisplayManager != null) {
            return sLeiaDisplayManager;
        }
        sLeiaDisplayManager = LeiaSDKImpl.getV3DisplayManager(appContext);
        if (sLeiaDisplayManager != null) {
            return sLeiaDisplayManager;
        }
        sLeiaDisplayManager = LeiaSDKImpl.getV2DisplayManager(appContext);
        if (sLeiaDisplayManager != null) {
            return sLeiaDisplayManager;
        }
        Log.i((String)TAG, (String)"We were unable to load the Leia Platform. This error is normally caused by running on a non-Leia device, or running with old (EVT0) firmware. If you feel this message is in error, please contact Leia for support");
        return null;
    }

    private static String getPlatformVersion() {
        Method[] methods;
        for (Method method : methods = LeiaLightsManager.class.getDeclaredMethods()) {
            if (!"getVersion".equals(method.getName())) continue;
            return LeiaLightsManager.getVersion();
        }
        return "2.0";
    }
}

