/*
 * Decompiled with CFR 0.152.
 */
package com.leia.android.lights;

import android.content.Context;
import android.util.Log;
import com.leia.android.lights.ColorProfile;
import com.leia.android.lights.ColorProfileUtil;
import com.leia.android.lights.DisplayConfig;
import com.leia.android.lights.ExceptionUtils;
import com.leia.android.lights.LeiaLightsManager;
import com.leiainc.androidsdk.display.BacklightEventListener;
import com.leiainc.androidsdk.display.LeiaDisplayManager;
import com.leiainc.androidsdk.display.LeiaDisplayManagerSource;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class LeiaDisplayManagerV3Impl
implements LeiaDisplayManager {
    private static final String TAG = "DisplayManagerV3Impl";
    private LeiaLightsManager mLeiaLightsManager;
    private Set<BacklightEventListener> mBacklightEventListeners = new HashSet<BacklightEventListener>();

    LeiaDisplayManagerV3Impl(LeiaLightsManager leiaLightsManager) {
        this.mLeiaLightsManager = leiaLightsManager;
    }

    @Override
    public String getPlatformVersion() {
        return LeiaLightsManager.getVersion();
    }

    @Override
    public LeiaDisplayManagerSource.BacklightMode getBacklightMode() {
        LeiaLightsManager.BacklightMode mode = this.mLeiaLightsManager.getBacklightMode();
        switch (mode) {
            case MODE_3D: {
                return LeiaDisplayManagerSource.BacklightMode.MODE_3D;
            }
            case MODE_2D: {
                return LeiaDisplayManagerSource.BacklightMode.MODE_2D;
            }
        }
        throw ExceptionUtils.createUnexpectedBacklightException(mode.name());
    }

    private ViewConfig getViewConfig() {
        LeiaLightsManager.ViewConfig viewConfig = this.mLeiaLightsManager.getViewConfig();
        return new ViewConfig(viewConfig.resolution.x, viewConfig.resolution.y, viewConfig.numberOfViews.x, viewConfig.numberOfViews.y);
    }

    private int getOffset(Orientation orientation) {
        switch (orientation) {
            case PORTRAIT: {
                return this.mLeiaLightsManager.getOffset(LeiaLightsManager.Orientation.PORTRAIT);
            }
            case LANDSCAPE: {
                return this.mLeiaLightsManager.getOffset(LeiaLightsManager.Orientation.LANDSCAPE);
            }
        }
        throw ExceptionUtils.createIllegalOrientationException();
    }

    private float[] getACT(Orientation orientation) {
        switch (orientation) {
            case PORTRAIT: {
                return this.mLeiaLightsManager.getACT(LeiaLightsManager.Orientation.PORTRAIT);
            }
            case LANDSCAPE: {
                return this.mLeiaLightsManager.getACT(LeiaLightsManager.Orientation.LANDSCAPE);
            }
        }
        throw ExceptionUtils.createIllegalOrientationException();
    }

    private int getSystemDisparity() {
        return this.mLeiaLightsManager.getSystemDisparity();
    }

    @Override
    public DisplayConfig getDisplayConfig() {
        DisplayConfig displayConfig = new DisplayConfig();
        ViewConfig viewConfig = this.getViewConfig();
        int systemDisparity = this.getSystemDisparity();
        int xOffset = this.getOffset(Orientation.PORTRAIT);
        int yOffset = this.getOffset(Orientation.LANDSCAPE);
        float[] xAct = this.getACT(Orientation.PORTRAIT);
        float[] yAct = this.getACT(Orientation.LANDSCAPE);
        displayConfig.mPanelResolution = new DisplayConfig.XyPair<Integer>(viewConfig.resolution.y, viewConfig.resolution.x);
        displayConfig.mAlignmentOffset = new DisplayConfig.XyPair<Float>(Float.valueOf(yOffset), Float.valueOf(xOffset));
        displayConfig.mViewSharpeningCoefficients = new DisplayConfig.XyPair<List<Float>>(Arrays.asList(Float.valueOf(yAct[0]), Float.valueOf(yAct[1])), Arrays.asList(Float.valueOf(xAct[0]), Float.valueOf(xAct[1])));
        displayConfig.mSystemDisparity = systemDisparity;
        displayConfig.mNumViews = new DisplayConfig.XyPair<Integer>(viewConfig.numberOfViews.y, viewConfig.numberOfViews.x);
        displayConfig.mDotPitchInMm = new DisplayConfig.XyPair<Float>(Float.valueOf(0.049305554f), Float.valueOf(0.04921875f));
        return displayConfig;
    }

    public void restoreDefaults() {
        this.mLeiaLightsManager.factoryReset();
    }

    public void setBrightnessLevel(int brightnessLevel) {
        this.mLeiaLightsManager.setBrightnessLevel(brightnessLevel);
    }

    public void setAlignmentOffset(float xOffset, float yOffset) {
        this.mLeiaLightsManager.setOffset(LeiaLightsManager.Orientation.PORTRAIT, (int)xOffset);
        this.mLeiaLightsManager.setOffset(LeiaLightsManager.Orientation.LANDSCAPE, (int)yOffset);
    }

    public void setViewSharpeningCoefficients(float xa, float xb, float ya, float yb) {
        this.mLeiaLightsManager.setACT(LeiaLightsManager.Orientation.PORTRAIT, xa, xb);
        this.mLeiaLightsManager.setACT(LeiaLightsManager.Orientation.LANDSCAPE, ya, yb);
    }

    public void setSystemDisparity(int d) {
        this.mLeiaLightsManager.setSystemDisparity(d);
    }

    public void setBacklightTransition(float ratio2d, float ratio3d) {
        Log.w((String)TAG, (String)"setBacklightTransition() unimplemented on this platform.");
    }

    public float[] getBacklightRatios(LeiaDisplayManagerSource.BacklightMode mode) {
        LeiaLightsManager.BacklightMode otherMode;
        switch (mode) {
            case MODE_2D: {
                otherMode = LeiaLightsManager.BacklightMode.MODE_2D;
                break;
            }
            case MODE_3D: {
                otherMode = LeiaLightsManager.BacklightMode.MODE_3D;
                break;
            }
            default: {
                throw ExceptionUtils.createIllegalBacklightArgumentException();
            }
        }
        return this.mLeiaLightsManager.getBacklightRatios(otherMode);
    }

    public void setBacklightRatios(LeiaDisplayManagerSource.BacklightMode mode, float ratio2d, float ratio3d) {
        LeiaLightsManager.BacklightMode otherMode;
        switch (mode) {
            case MODE_2D: {
                otherMode = LeiaLightsManager.BacklightMode.MODE_2D;
                break;
            }
            case MODE_3D: {
                otherMode = LeiaLightsManager.BacklightMode.MODE_3D;
                break;
            }
            default: {
                throw ExceptionUtils.createIllegalBacklightArgumentException();
            }
        }
        this.mLeiaLightsManager.setBacklightRatios(otherMode, ratio2d, ratio3d);
    }

    public void setColorProfile(LeiaDisplayManagerSource.BacklightMode mode, ColorProfile colorProfile, Context context) {
        ColorProfileUtil.setColorProfile(mode, colorProfile, context);
    }

    @Override
    public void setBacklightMode(LeiaDisplayManagerSource.BacklightMode backlightMode) {
        this.requestBacklightMode(backlightMode);
    }

    @Override
    public void requestBacklightMode(LeiaDisplayManagerSource.BacklightMode backlightMode) {
        LeiaLightsManager.BacklightMode otherEnumType;
        if (this.getBacklightMode() == backlightMode) {
            return;
        }
        for (BacklightEventListener listener : this.mBacklightEventListeners) {
            listener.onBacklightModeChanged(backlightMode);
        }
        switch (backlightMode) {
            case MODE_3D: {
                otherEnumType = LeiaLightsManager.BacklightMode.MODE_3D;
                break;
            }
            case MODE_2D: {
                otherEnumType = LeiaLightsManager.BacklightMode.MODE_2D;
                break;
            }
            default: {
                throw ExceptionUtils.createIllegalBacklightArgumentException();
            }
        }
        this.mLeiaLightsManager.setBacklightMode(otherEnumType);
    }

    @Override
    public void registerBacklightEventListener(BacklightEventListener backlightEventListener) {
        this.mBacklightEventListeners.add(backlightEventListener);
    }

    @Override
    public void deregisterBacklightEventListener(BacklightEventListener backlightEventListener) {
        this.mBacklightEventListeners.remove(backlightEventListener);
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onWindowFocusedChanged(boolean hasFocus) {
    }

    static enum Orientation {
        LANDSCAPE,
        PORTRAIT;

    }

    static class ViewConfig {
        Resolution resolution;
        NumberOfViews numberOfViews;

        ViewConfig(int resX, int resY, int viewX, int viewY) {
            this.resolution = new Resolution(resX, resY);
            this.numberOfViews = new NumberOfViews(viewX, viewY);
        }

        public String toString() {
            return "ViewConfig{resolution=" + this.resolution + ", numberOfViews=" + this.numberOfViews + '}';
        }

        static class NumberOfViews {
            int x;
            int y;

            NumberOfViews(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public String toString() {
                return "NumberOfViews{x=" + this.x + ", y=" + this.y + '}';
            }
        }

        static class Resolution {
            int x;
            int y;

            Resolution(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public String toString() {
                return "Resolution{x=" + this.x + ", y=" + this.y + '}';
            }
        }
    }
}

