/*
 * Decompiled with CFR 0.152.
 */
package com.leia.android.lights;

import com.leiainc.androidsdk.display.config.ClockwiseOrientation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisplayConfig {
    XyPair<Float> mDotPitchInMm;
    XyPair<Integer> mPanelResolution;
    XyPair<Integer> mNumViews;
    XyPair<Float> mAlignmentOffset;
    XyPair<List<Float>> mViewSharpeningCoefficients;
    int mSystemDisparity;
    Map<ClockwiseOrientation, int[][]> mInterlacingConfigs = new HashMap<ClockwiseOrientation, int[][]>(0);

    DisplayConfig() {
    }

    public XyPair<Float> getDotPitchInMm() {
        return this.mDotPitchInMm;
    }

    public XyPair<Integer> getPanelResolution() {
        return this.mPanelResolution;
    }

    public XyPair<Integer> getNumViews() {
        return this.mNumViews;
    }

    public XyPair<Float> getAlignmentOffset() {
        return this.mAlignmentOffset;
    }

    public XyPair<List<Float>> getViewSharpeningCoefficients() {
        return this.mViewSharpeningCoefficients;
    }

    public int getSystemDisparity() {
        return this.mSystemDisparity;
    }

    public XyPair<Integer> getDisplaySizeInMm() {
        int xDisplaySize = (int)((float)((Integer)this.getPanelResolution().x).intValue() * ((Float)this.getDotPitchInMm().x).floatValue());
        int yDisplaySize = (int)((float)((Integer)this.getPanelResolution().y).intValue() * ((Float)this.getDotPitchInMm().y).floatValue());
        return new XyPair<Integer>(xDisplaySize, yDisplaySize);
    }

    public XyPair<Integer> getViewResolution() {
        int xViewResolution = (Integer)this.getPanelResolution().x / (Integer)this.getNumViews().x;
        int yViewResolution = (Integer)this.getPanelResolution().y / (Integer)this.getNumViews().y;
        return new XyPair<Integer>(xViewResolution, yViewResolution);
    }

    public XyPair<List<Float>> getViewSharpeningKernel() {
        List<Float> xKernel = this.viewSharpeningCoefficientsToKernel(((Float)((List)this.mViewSharpeningCoefficients.x).get(0)).floatValue(), ((Float)((List)this.mViewSharpeningCoefficients.x).get(1)).floatValue());
        List<Float> yKernel = this.viewSharpeningCoefficientsToKernel(((Float)((List)this.mViewSharpeningCoefficients.y).get(0)).floatValue(), ((Float)((List)this.mViewSharpeningCoefficients.y).get(1)).floatValue());
        return new XyPair<List<Float>>(xKernel, yKernel);
    }

    public Map<ClockwiseOrientation, int[][]> getInterlacingConfigs() {
        return this.mInterlacingConfigs;
    }

    private List<Float> viewSharpeningCoefficientsToKernel(float a, float b) {
        float denominator = 1.0f - 2.0f * a - 2.0f * b;
        ArrayList<Float> kernel = new ArrayList<Float>(5);
        kernel.add(Float.valueOf(-b / denominator));
        kernel.add(Float.valueOf(-a / denominator));
        kernel.add(Float.valueOf(1.0f / denominator));
        kernel.add(Float.valueOf(-a / denominator));
        kernel.add(Float.valueOf(-b / denominator));
        return kernel;
    }

    public String toString() {
        return "DisplayConfig{\n  mDotPitchInMm=" + this.mDotPitchInMm + ",\n  mPanelResolution=" + this.mPanelResolution + ",\n  mNumViews=" + this.mNumViews + ",\n  mAlignmentOffset=" + this.mAlignmentOffset + ",\n  mViewSharpeningCoefficients=" + this.mViewSharpeningCoefficients + ",\n  mSystemDisparity=" + this.mSystemDisparity + ",\n}";
    }

    public static class XyPair<T> {
        public final T x;
        public final T y;

        public XyPair(T x, T y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "{x=" + this.arrayToStringHelper(this.x) + ", y=" + this.arrayToStringHelper(this.y) + '}';
        }

        private String arrayToStringHelper(T a) {
            if (a instanceof float[]) {
                return Arrays.toString((float[])a);
            }
            return a.toString();
        }
    }
}

