/*
 * Decompiled with CFR 0.152.
 */
package com.leia.android.lights;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import com.leia.android.lights.ForegroundTester;
import com.leia.android.lights.LeiaLightsManagerV5;
import com.leiainc.androidsdk.display.BacklightDisableReason;
import com.leiainc.androidsdk.display.BacklightEventListener;
import com.leiainc.androidsdk.display.LeiaDisplayManagerSource;
import java.util.HashSet;
import java.util.Set;

class BacklightModeStateMachineV5 {
    private static final String TAG = BacklightModeStateMachineV5.class.getSimpleName();
    private static final String ACTION_3DMODE_UNAVAILABLE = "com.leia.broadcast.3DMODE_DISABLED";
    private static final String ACTION_3DMODE_AVAILABLE = "com.leia.broadcast.3DMODE_ENABLED";
    private final Set<BacklightEventListener> mListeners = new HashSet<BacklightEventListener>();
    private Context mContext;
    private IntentFilter mFilter;
    private LeiaLightsManagerV5.BacklightMode mLastBacklightMode;
    private Set<BacklightDisableReason> mBacklightDisableReasons;
    private boolean mIs3dAvailable;
    private boolean mIs3DRequested;
    private LeiaLightsManagerV5 mLeiaLightManager;
    private boolean mHasFocus = true;

    BacklightModeStateMachineV5(Context context, LeiaLightsManagerV5 leiaLightsManager) {
        this.mLeiaLightManager = leiaLightsManager;
        this.mContext = context;
        this.mFilter = new IntentFilter();
        this.mFilter.addAction(ACTION_3DMODE_AVAILABLE);
        this.mFilter.addAction(ACTION_3DMODE_UNAVAILABLE);
        context.registerReceiver((BroadcastReceiver)new BroadcastReceiverV5(), this.mFilter);
        this.mBacklightDisableReasons = new HashSet<BacklightDisableReason>();
        this.mIs3dAvailable = leiaLightsManager.is3DModeAvailable();
        this.mLastBacklightMode = this.mLeiaLightManager.getBacklightMode();
    }

    void requestBacklightMode(LeiaDisplayManagerSource.BacklightMode requestedBacklightMode) {
        this.mIs3DRequested = requestedBacklightMode == LeiaDisplayManagerSource.BacklightMode.MODE_3D;
        this.idempotentUpdateBacklightMode();
    }

    private void idempotentUpdateBacklightDisableReasons(Set<BacklightDisableReason> newReasons) {
        if (!this.mBacklightDisableReasons.equals(newReasons)) {
            this.mBacklightDisableReasons = new HashSet<BacklightDisableReason>(newReasons);
            this.notifyDisableReasonListeners(this.mBacklightDisableReasons);
        }
    }

    private void idempotentUpdateBacklightMode() {
        LeiaLightsManagerV5.BacklightMode currentBacklightMode;
        if (!ForegroundTester.checkAppIsInForeground()) {
            return;
        }
        LeiaLightsManagerV5.BacklightMode targetBacklightMode = this.mIs3DRequested && this.mIs3dAvailable && this.mHasFocus ? LeiaLightsManagerV5.BacklightMode.MODE_3D : LeiaLightsManagerV5.BacklightMode.MODE_2D;
        if (this.mLeiaLightManager.getBacklightMode() != targetBacklightMode) {
            this.mLeiaLightManager.setBacklightMode(targetBacklightMode);
        }
        if ((currentBacklightMode = this.mLeiaLightManager.getBacklightMode()) != this.mLastBacklightMode) {
            this.mLastBacklightMode = currentBacklightMode;
            this.notifyModeListeners(currentBacklightMode == LeiaLightsManagerV5.BacklightMode.MODE_3D ? LeiaDisplayManagerSource.BacklightMode.MODE_3D : LeiaDisplayManagerSource.BacklightMode.MODE_2D);
        }
    }

    void registerBacklightEventListener(BacklightEventListener backlightEventListener) {
        this.mListeners.add(backlightEventListener);
    }

    void deregisterBacklightEventListener(BacklightEventListener backlightEventListener) {
        this.mListeners.remove(backlightEventListener);
    }

    void onPause() {
        this.idempotentUpdateBacklightMode();
        HashSet<BacklightDisableReason> newReasons = new HashSet<BacklightDisableReason>(this.mBacklightDisableReasons);
        newReasons.add(BacklightDisableReason.FOCUS_CHANGED);
        this.idempotentUpdateBacklightDisableReasons(newReasons);
    }

    void onResume() {
        this.idempotentUpdateBacklightMode();
        HashSet<BacklightDisableReason> newReasons = new HashSet<BacklightDisableReason>(this.mBacklightDisableReasons);
        newReasons.remove((Object)BacklightDisableReason.FOCUS_CHANGED);
        this.idempotentUpdateBacklightDisableReasons(newReasons);
    }

    void onWindowFocusedChanged(boolean hasFocus) {
        this.mHasFocus = hasFocus;
        this.idempotentUpdateBacklightMode();
        HashSet<BacklightDisableReason> newReasons = new HashSet<BacklightDisableReason>(this.mBacklightDisableReasons);
        if (hasFocus) {
            newReasons.remove((Object)BacklightDisableReason.FOCUS_CHANGED);
        } else {
            newReasons.add(BacklightDisableReason.FOCUS_CHANGED);
        }
        this.idempotentUpdateBacklightDisableReasons(newReasons);
    }

    private void notifyModeListeners(LeiaDisplayManagerSource.BacklightMode backlightMode) {
        for (BacklightEventListener listener : this.mListeners) {
            if (listener == null) continue;
            listener.onBacklightModeChanged(backlightMode);
        }
    }

    private void notifyDisableReasonListeners(Set<BacklightDisableReason> disableReasons) {
        for (BacklightEventListener listener : this.mListeners) {
            if (listener == null) continue;
            HashSet<BacklightDisableReason> r = new HashSet<BacklightDisableReason>(disableReasons);
            listener.onBacklightDisableReasonChanged(r);
        }
    }

    protected class BroadcastReceiverV6
    extends BroadcastReceiver {
        protected BroadcastReceiverV6() {
        }

        public void onReceive(Context context, Intent intent) {
            String[] reasonStrings;
            String action = intent.getAction();
            if (BacklightModeStateMachineV5.ACTION_3DMODE_UNAVAILABLE.equals(action)) {
                BacklightModeStateMachineV5.this.mIs3dAvailable = false;
            } else if (BacklightModeStateMachineV5.ACTION_3DMODE_AVAILABLE.equals(action)) {
                BacklightModeStateMachineV5.this.mIs3dAvailable = true;
            }
            BacklightModeStateMachineV5.this.idempotentUpdateBacklightMode();
            Bundle extra = intent.getExtras();
            HashSet<BacklightDisableReason> disableReasons = new HashSet<BacklightDisableReason>();
            if (extra != null && (reasonStrings = extra.getStringArray("com.android.server.lights.DisableReasons")) != null) {
                for (String reasonString : reasonStrings) {
                    try {
                        BacklightDisableReason r = BacklightDisableReason.valueOf(reasonString);
                        disableReasons.add(r);
                    }
                    catch (IllegalArgumentException e) {
                        Log.d((String)TAG, (String)("Unknown disable reason '" + reasonString + "' caused exception: " + e));
                    }
                }
            }
            BacklightModeStateMachineV5.this.idempotentUpdateBacklightDisableReasons(disableReasons);
        }
    }

    protected class BroadcastReceiverV5
    extends BroadcastReceiver {
        protected BroadcastReceiverV5() {
        }

        public void onReceive(Context context, Intent intent) {
            Bundle extra = intent.getExtras();
            if (extra != null && extra.containsKey("com.android.server.lights.DisableReasons")) {
                BacklightModeStateMachineV5.this.mContext.unregisterReceiver((BroadcastReceiver)this);
                BroadcastReceiverV6 r = new BroadcastReceiverV6();
                BacklightModeStateMachineV5.this.mContext.registerReceiver((BroadcastReceiver)r, BacklightModeStateMachineV5.this.mFilter);
                r.onReceive(context, intent);
                return;
            }
            String action = intent.getAction();
            if (BacklightModeStateMachineV5.ACTION_3DMODE_UNAVAILABLE.equals(action)) {
                BacklightModeStateMachineV5.this.mIs3dAvailable = false;
            } else if (BacklightModeStateMachineV5.ACTION_3DMODE_AVAILABLE.equals(action)) {
                BacklightModeStateMachineV5.this.mIs3dAvailable = true;
            }
            BacklightModeStateMachineV5.this.idempotentUpdateBacklightMode();
        }
    }
}

