/*
 * Decompiled with CFR 0.152.
 */
package com.leia.android.lights;

import android.content.Context;
import com.leia.android.lights.BacklightModeStateMachineV5;
import com.leia.android.lights.ColorProfile;
import com.leia.android.lights.DisplayConfig;
import com.leia.android.lights.ExceptionUtils;
import com.leia.android.lights.ForegroundTester;
import com.leia.android.lights.LeiaLightsManagerV5;
import com.leiainc.androidsdk.display.BacklightEventListener;
import com.leiainc.androidsdk.display.LeiaDisplayManager;
import java.util.Arrays;
import java.util.List;

class LeiaDisplayManagerV5Impl
implements LeiaDisplayManager {
    private LeiaLightsManagerV5 mLeiaLightsManager;
    private BacklightModeStateMachineV5 mBacklightModeStateMachine;

    LeiaDisplayManagerV5Impl(Context context, LeiaLightsManagerV5 leiaLightsManager) {
        this.mLeiaLightsManager = leiaLightsManager;
        this.mBacklightModeStateMachine = new BacklightModeStateMachineV5(context, leiaLightsManager);
    }

    @Override
    public String getPlatformVersion() {
        return "5.0";
    }

    @Override
    public LeiaDisplayManager.BacklightMode getBacklightMode() {
        LeiaLightsManagerV5.BacklightMode mode = this.mLeiaLightsManager.getBacklightMode();
        switch (mode) {
            case MODE_TRANSITION: 
            case MODE_3D: {
                return LeiaDisplayManager.BacklightMode.MODE_3D;
            }
            case MODE_2D: {
                return LeiaDisplayManager.BacklightMode.MODE_2D;
            }
        }
        throw ExceptionUtils.createUnexpectedBacklightException(mode.name());
    }

    private ViewConfig getViewConfig() {
        LeiaLightsManagerV5.ViewConfig viewConfig = this.mLeiaLightsManager.getViewConfig();
        return new ViewConfig(viewConfig.resolution.x, viewConfig.resolution.y, viewConfig.numberOfViews.x, viewConfig.numberOfViews.y);
    }

    private int getOffset(Orientation orientation) {
        switch (orientation) {
            case PORTRAIT: {
                return this.mLeiaLightsManager.getOffset(LeiaLightsManagerV5.Orientation.PORTRAIT);
            }
            case LANDSCAPE: {
                return this.mLeiaLightsManager.getOffset(LeiaLightsManagerV5.Orientation.LANDSCAPE);
            }
        }
        throw ExceptionUtils.createIllegalOrientationException();
    }

    private float[] getACT(Orientation orientation) {
        switch (orientation) {
            case PORTRAIT: {
                return this.mLeiaLightsManager.getACT(LeiaLightsManagerV5.Orientation.PORTRAIT);
            }
            case LANDSCAPE: {
                return this.mLeiaLightsManager.getACT(LeiaLightsManagerV5.Orientation.LANDSCAPE);
            }
        }
        throw ExceptionUtils.createIllegalOrientationException();
    }

    private int getSystemDisparity() {
        int systemDisparity = this.mLeiaLightsManager.getSystemDisparity();
        if (systemDisparity == -1) {
            return 8;
        }
        return systemDisparity;
    }

    @Override
    public DisplayConfig getDisplayConfig() {
        DisplayConfig displayConfig = new DisplayConfig();
        ViewConfig viewConfig = this.getViewConfig();
        int systemDisparity = this.getSystemDisparity();
        int xOffset = this.getOffset(Orientation.PORTRAIT);
        int yOffset = this.getOffset(Orientation.LANDSCAPE);
        float[] xAct = this.getACT(Orientation.PORTRAIT);
        float[] yAct = this.getACT(Orientation.LANDSCAPE);
        if (xAct == null) {
            xAct = new float[]{0.09f, 0.035f};
        }
        if (yAct == null) {
            yAct = new float[]{0.08f, 0.03f};
        }
        if (yAct[0] == 0.002f && yAct[1] == 0.003f) {
            yAct[0] = 0.08f;
            yAct[1] = 0.03f;
        }
        displayConfig.mPanelResolution = new DisplayConfig.XyPair<Integer>(viewConfig.resolution.y, viewConfig.resolution.x);
        displayConfig.mAlignmentOffset = new DisplayConfig.XyPair<Float>(Float.valueOf(xOffset), Float.valueOf(yOffset));
        displayConfig.mViewSharpeningCoefficients = new DisplayConfig.XyPair<List<Float>>(Arrays.asList(Float.valueOf(xAct[0]), Float.valueOf(xAct[1])), Arrays.asList(Float.valueOf(yAct[0]), Float.valueOf(yAct[1])));
        displayConfig.mSystemDisparity = systemDisparity;
        displayConfig.mNumViews = new DisplayConfig.XyPair<Integer>(viewConfig.numberOfViews.y, viewConfig.numberOfViews.x);
        displayConfig.mDotPitchInMm = new DisplayConfig.XyPair<Float>(Float.valueOf(0.049305554f), Float.valueOf(0.04921875f));
        return displayConfig;
    }

    @Override
    public void registerBacklightEventListener(BacklightEventListener backlightEventListener) {
        this.mBacklightModeStateMachine.registerBacklightEventListener(backlightEventListener);
    }

    @Override
    public void deregisterBacklightEventListener(BacklightEventListener backlightEventListener) {
        this.mBacklightModeStateMachine.deregisterBacklightEventListener(backlightEventListener);
    }

    public void restoreDefaults() {
        this.mLeiaLightsManager.factoryReset();
    }

    public void setBrightnessLevel(int brightnessLevel) {
        if (!ForegroundTester.checkAppIsInForeground()) {
            return;
        }
        this.mLeiaLightsManager.setBrightnessLevel(brightnessLevel);
    }

    public void setAlignmentOffset(float xOffset, float yOffset) {
        if (!ForegroundTester.checkAppIsInForeground()) {
            return;
        }
        this.mLeiaLightsManager.setOffset(LeiaLightsManagerV5.Orientation.PORTRAIT, (int)xOffset);
        this.mLeiaLightsManager.setOffset(LeiaLightsManagerV5.Orientation.LANDSCAPE, (int)yOffset);
    }

    public void setViewSharpeningCoefficients(float xa, float xb, float ya, float yb) {
        if (!ForegroundTester.checkAppIsInForeground()) {
            return;
        }
        this.mLeiaLightsManager.setACT(LeiaLightsManagerV5.Orientation.PORTRAIT, xa, xb);
        this.mLeiaLightsManager.setACT(LeiaLightsManagerV5.Orientation.LANDSCAPE, ya, yb);
    }

    public void setSystemDisparity(int d) {
        if (!ForegroundTester.checkAppIsInForeground()) {
            return;
        }
        this.mLeiaLightsManager.setSystemDisparity(d);
    }

    public void setBacklightTransition(float ratio2d, float ratio3d) {
        if (!ForegroundTester.checkAppIsInForeground()) {
            return;
        }
        this.mLeiaLightsManager.setBacklightTransition(ratio2d, ratio3d);
    }

    public float[] getBacklightRatios(LeiaDisplayManager.BacklightMode mode) {
        LeiaLightsManagerV5.BacklightMode otherMode;
        switch (mode) {
            case MODE_2D: {
                otherMode = LeiaLightsManagerV5.BacklightMode.MODE_2D;
                break;
            }
            case MODE_3D: {
                otherMode = LeiaLightsManagerV5.BacklightMode.MODE_3D;
                break;
            }
            default: {
                throw ExceptionUtils.createIllegalBacklightArgumentException();
            }
        }
        float[] backlightRatios = this.mLeiaLightsManager.getBacklightRatios(otherMode);
        if (backlightRatios == null) {
            switch (mode) {
                case MODE_2D: {
                    return new float[]{1.0f, 0.1f};
                }
                case MODE_3D: {
                    return new float[]{0.0f, 1.0f};
                }
            }
        }
        return backlightRatios;
    }

    public void setBacklightRatios(LeiaDisplayManager.BacklightMode mode, float ratio2d, float ratio3d) {
        LeiaLightsManagerV5.BacklightMode otherMode;
        if (!ForegroundTester.checkAppIsInForeground()) {
            return;
        }
        switch (mode) {
            case MODE_2D: {
                otherMode = LeiaLightsManagerV5.BacklightMode.MODE_2D;
                break;
            }
            case MODE_3D: {
                otherMode = LeiaLightsManagerV5.BacklightMode.MODE_3D;
                break;
            }
            default: {
                throw ExceptionUtils.createIllegalBacklightArgumentException();
            }
        }
        this.mLeiaLightsManager.setBacklightRatios(otherMode, ratio2d, ratio3d);
    }

    public void setColorProfile(LeiaDisplayManager.BacklightMode mode, ColorProfile colorProfile, Context context) {
        LeiaLightsManagerV5.BacklightMode otherMode;
        if (!ForegroundTester.checkAppIsInForeground()) {
            return;
        }
        switch (mode) {
            case MODE_2D: {
                otherMode = LeiaLightsManagerV5.BacklightMode.MODE_2D;
                break;
            }
            case MODE_3D: {
                otherMode = LeiaLightsManagerV5.BacklightMode.MODE_3D;
                break;
            }
            default: {
                throw ExceptionUtils.createIllegalBacklightArgumentException();
            }
        }
        LeiaLightsManagerV5.ColorProfile otherColorProfile = LeiaLightsManagerV5.ColorProfile.values()[colorProfile.mSystemCode];
        this.mLeiaLightsManager.setColorProfile(otherMode, otherColorProfile);
    }

    @Override
    public void setBacklightMode(LeiaDisplayManager.BacklightMode backlightMode) {
        this.requestBacklightMode(backlightMode);
    }

    @Override
    public void requestBacklightMode(LeiaDisplayManager.BacklightMode backlightMode) {
        if (!ForegroundTester.checkAppIsInForeground()) {
            return;
        }
        this.mBacklightModeStateMachine.requestBacklightMode(backlightMode);
    }

    @Override
    public void onResume() {
        this.mBacklightModeStateMachine.onResume();
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onWindowFocusedChanged(boolean hasFocus) {
        this.mBacklightModeStateMachine.onWindowFocusedChanged(hasFocus);
    }

    static enum Orientation {
        LANDSCAPE,
        PORTRAIT;

    }

    static class ViewConfig {
        Resolution resolution;
        NumberOfViews numberOfViews;

        ViewConfig(int resX, int resY, int viewX, int viewY) {
            this.resolution = new Resolution(resX, resY);
            this.numberOfViews = new NumberOfViews(viewX, viewY);
        }

        public String toString() {
            return "ViewConfig{resolution=" + this.resolution + ", numberOfViews=" + this.numberOfViews + '}';
        }

        static class NumberOfViews {
            int x;
            int y;

            NumberOfViews(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public String toString() {
                return "NumberOfViews{x=" + this.x + ", y=" + this.y + '}';
            }
        }

        static class Resolution {
            int x;
            int y;

            Resolution(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public String toString() {
                return "Resolution{x=" + this.x + ", y=" + this.y + '}';
            }
        }
    }
}

