/*
 * Decompiled with CFR 0.152.
 */
package com.leia.android.lights;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import com.leia.android.lights.ForegroundTester;
import com.leia.android.lights.LeiaLightsManagerV6;
import com.leiainc.androidsdk.display.BacklightDisableReason;
import com.leiainc.androidsdk.display.BacklightEventListener;
import com.leiainc.androidsdk.display.LeiaDisplayManager;
import java.util.HashSet;
import java.util.Set;

class BacklightModeStateMachineV6 {
    private static final String TAG = BacklightModeStateMachineV6.class.getSimpleName();
    private static final String ACTION_3DMODE_UNAVAILABLE = "com.leia.broadcast.3DMODE_DISABLED";
    private static final String ACTION_3DMODE_AVAILABLE = "com.leia.broadcast.3DMODE_ENABLED";
    private final Set<BacklightEventListener> mListeners = new HashSet<BacklightEventListener>();
    private LeiaLightsManagerV6.BacklightMode mLastBacklightMode;
    private Set<BacklightDisableReason> mBacklightDisableReasons;
    private boolean mIs3dAvailable;
    private boolean mIs3DRequested;
    private LeiaLightsManagerV6 mLeiaLightManager;
    private boolean mHasFocus = true;

    BacklightModeStateMachineV6(Context context, LeiaLightsManagerV6 leiaLightsManager) {
        this.mLeiaLightManager = leiaLightsManager;
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_3DMODE_AVAILABLE);
        filter.addAction(ACTION_3DMODE_UNAVAILABLE);
        context.registerReceiver((BroadcastReceiver)new BroadcastReceiverV6(), filter);
        this.mBacklightDisableReasons = new HashSet<BacklightDisableReason>();
        int backlightDisableReasonsBitmask = this.mLeiaLightManager.get2dFallbackReason();
        this.populateDisableReasonsSet(backlightDisableReasonsBitmask);
        this.mIs3dAvailable = leiaLightsManager.is3DModeAvailable();
        this.mLastBacklightMode = this.mLeiaLightManager.getBacklightMode();
    }

    void requestBacklightMode(LeiaDisplayManager.BacklightMode requestedBacklightMode) {
        this.mIs3DRequested = requestedBacklightMode == LeiaDisplayManager.BacklightMode.MODE_3D;
        this.idempotentUpdateBacklightMode();
    }

    private void idempotentUpdateBacklightDisableReasons(Set<BacklightDisableReason> newReasons) {
        if (!this.mBacklightDisableReasons.equals(newReasons)) {
            this.mBacklightDisableReasons = new HashSet<BacklightDisableReason>(newReasons);
            this.notifyDisableReasonListeners(this.mBacklightDisableReasons);
        }
    }

    private void idempotentUpdateBacklightMode() {
        LeiaLightsManagerV6.BacklightMode currentBacklightMode;
        if (!ForegroundTester.checkAppIsInForeground()) {
            return;
        }
        LeiaLightsManagerV6.BacklightMode targetBacklightMode = this.mIs3DRequested && this.mIs3dAvailable && this.mHasFocus ? LeiaLightsManagerV6.BacklightMode.MODE_3D : LeiaLightsManagerV6.BacklightMode.MODE_2D;
        if (this.mLeiaLightManager.getBacklightMode() != targetBacklightMode) {
            this.mLeiaLightManager.setBacklightMode(targetBacklightMode);
        }
        if ((currentBacklightMode = this.mLeiaLightManager.getBacklightMode()) != this.mLastBacklightMode) {
            this.mLastBacklightMode = currentBacklightMode;
            this.notifyModeListeners(currentBacklightMode == LeiaLightsManagerV6.BacklightMode.MODE_3D ? LeiaDisplayManager.BacklightMode.MODE_3D : LeiaDisplayManager.BacklightMode.MODE_2D);
        }
    }

    void registerBacklightEventListener(BacklightEventListener backlightEventListener) {
        this.mListeners.add(backlightEventListener);
        if (!this.mBacklightDisableReasons.isEmpty() && backlightEventListener != null) {
            HashSet<BacklightDisableReason> r = new HashSet<BacklightDisableReason>(this.mBacklightDisableReasons);
            backlightEventListener.onBacklightDisableReasonChanged(r);
        }
    }

    void deregisterBacklightEventListener(BacklightEventListener backlightEventListener) {
        this.mListeners.remove(backlightEventListener);
    }

    void onPause() {
        this.idempotentUpdateBacklightMode();
        HashSet<BacklightDisableReason> newReasons = new HashSet<BacklightDisableReason>(this.mBacklightDisableReasons);
        newReasons.add(BacklightDisableReason.FOCUS_CHANGED);
        this.idempotentUpdateBacklightDisableReasons(newReasons);
    }

    void onResume() {
        this.idempotentUpdateBacklightMode();
        HashSet<BacklightDisableReason> newReasons = new HashSet<BacklightDisableReason>(this.mBacklightDisableReasons);
        newReasons.remove((Object)BacklightDisableReason.FOCUS_CHANGED);
        this.idempotentUpdateBacklightDisableReasons(newReasons);
    }

    void onWindowFocusedChanged(boolean hasFocus) {
        this.mHasFocus = hasFocus;
        this.idempotentUpdateBacklightMode();
        HashSet<BacklightDisableReason> newReasons = new HashSet<BacklightDisableReason>(this.mBacklightDisableReasons);
        if (hasFocus) {
            newReasons.remove((Object)BacklightDisableReason.FOCUS_CHANGED);
        } else {
            newReasons.add(BacklightDisableReason.FOCUS_CHANGED);
        }
        this.idempotentUpdateBacklightDisableReasons(newReasons);
    }

    private void populateDisableReasonsSet(int bitmask) {
        for (BacklightDisableReason r : BacklightDisableReason.values()) {
            if ((bitmask & r.getVal()) == 0) continue;
            this.mBacklightDisableReasons.add(r);
        }
    }

    private void notifyModeListeners(LeiaDisplayManager.BacklightMode backlightMode) {
        for (BacklightEventListener listener : this.mListeners) {
            if (listener == null) continue;
            listener.onBacklightModeChanged(backlightMode);
        }
    }

    private void notifyDisableReasonListeners(Set<BacklightDisableReason> disableReasons) {
        for (BacklightEventListener listener : this.mListeners) {
            if (listener == null) continue;
            HashSet<BacklightDisableReason> r = new HashSet<BacklightDisableReason>(disableReasons);
            listener.onBacklightDisableReasonChanged(r);
        }
    }

    protected class BroadcastReceiverV6
    extends BroadcastReceiver {
        protected BroadcastReceiverV6() {
        }

        public void onReceive(Context context, Intent intent) {
            String[] reasonStrings;
            String action = intent.getAction();
            if (BacklightModeStateMachineV6.ACTION_3DMODE_UNAVAILABLE.equals(action)) {
                BacklightModeStateMachineV6.this.mIs3dAvailable = false;
            } else if (BacklightModeStateMachineV6.ACTION_3DMODE_AVAILABLE.equals(action)) {
                BacklightModeStateMachineV6.this.mIs3dAvailable = true;
            }
            BacklightModeStateMachineV6.this.idempotentUpdateBacklightMode();
            Bundle extra = intent.getExtras();
            HashSet<BacklightDisableReason> disableReasons = new HashSet<BacklightDisableReason>();
            if (extra != null && (reasonStrings = extra.getStringArray("com.android.server.lights.DisableReasons")) != null) {
                for (String reasonString : reasonStrings) {
                    try {
                        BacklightDisableReason r = BacklightDisableReason.valueOf(reasonString);
                        disableReasons.add(r);
                    }
                    catch (IllegalArgumentException e) {
                        Log.d((String)TAG, (String)("Unknown disable reason '" + reasonString + "' caused exception: " + e));
                    }
                }
            }
            BacklightModeStateMachineV6.this.idempotentUpdateBacklightDisableReasons(disableReasons);
        }
    }
}

