/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.codegen.models;

import com.legstar.codegen.CodeGenHelper;
import com.legstar.codegen.CodeGenMakeException;
import com.legstar.codegen.CodeGenUtil;
import com.legstar.codegen.CodeGenVelocityException;
import com.legstar.codegen.models.AbstractPropertiesModel;
import com.legstar.codegen.models.IAntBuildModel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractAntBuildModel
extends AbstractPropertiesModel
implements IAntBuildModel {
    private String mProductLocation;
    private File mProbeFile;
    public static final String ANT_FILE_SUFFIX = "xml";
    public static final String ANT_FILE_PREFIX = "build-";
    private Map<String, Object> mParameters;
    private final Log _log = LogFactory.getLog(this.getClass());

    public AbstractAntBuildModel() {
    }

    public AbstractAntBuildModel(Properties props) {
        super(props);
    }

    public void generateBuild(String generatorName, String velocityMacro, File targetFile) throws CodeGenMakeException {
        this.generateBuild(generatorName, velocityMacro, targetFile, null);
    }

    public void generateBuild(String generatorName, String velocityMacro, File targetFile, String targetCharsetName) throws CodeGenMakeException {
        try {
            if (this.mParameters == null) {
                CodeGenUtil.initVelocity();
                CodeGenHelper helper = new CodeGenHelper();
                this.mParameters = new HashMap<String, Object>();
                this.mParameters.put("helper", helper);
            }
            CodeGenUtil.processTemplate(generatorName, velocityMacro, "antModel", this, this.mParameters, targetFile, targetCharsetName);
            if (this._log.isDebugEnabled()) {
                try {
                    this._log.debug((Object)FileUtils.readFileToString((File)targetFile));
                }
                catch (IOException e) {
                    this._log.debug((Object)("Unable to read file " + targetFile), (Throwable)e);
                }
            }
        }
        catch (CodeGenVelocityException e) {
            throw new CodeGenMakeException(e);
        }
    }

    public String getProductLocation() {
        return this.mProductLocation;
    }

    public void setProductLocation(String productLocation) {
        this.mProductLocation = productLocation;
    }

    public File getProbeFile() {
        return this.mProbeFile;
    }

    public void setProbeFile(File probeFile) {
        this.mProbeFile = probeFile;
    }

    public Properties toProperties() {
        Properties props = super.toProperties();
        return props;
    }
}

