/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.apps.trx;

import com.ledger.lib.LedgerException;
import com.ledger.lib.apps.LedgerApplication;
import com.ledger.lib.apps.common.ECDSADeviceSignature;
import com.ledger.lib.apps.common.WalletAddress;
import com.ledger.lib.apps.trx.CustomContractNotEnabledException;
import com.ledger.lib.apps.trx.TrxCache;
import com.ledger.lib.transport.LedgerDevice;
import com.ledger.lib.utils.ApduExchange;
import com.ledger.lib.utils.BIP32Helper;
import com.ledger.lib.utils.SerializeHelper;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Vector;

public class Trx
extends LedgerApplication {
    private static final int TRX_CLA = 224;
    private static final int INS_GET_PUBLIC_ADDRESS = 2;
    private static final int INS_SIGN_TRANSACTION = 4;
    private static final int INS_GET_APPLICATION_CONFIGURATION = 6;
    private static final int INS_SIGN_PERSONAL_MESSAGE = 8;
    private static final int INS_GET_ECDH_SECRET = 10;
    private static final int P1_NO_DISPLAY = 0;
    private static final int P1_DISPLAY = 1;
    private static final int P1_SINGLE = 16;
    private static final int P1_FIRST_BLOCK = 0;
    private static final int P1_NEXT_BLOCK = 128;
    private static final int P1_SIGNATURE_MARKER = 160;
    private static final int P1_END = 144;
    private static final int P1_END_SIGNATURE_MARKER = 8;
    private static final int P2_NO_CHAINCODE = 0;
    private static final int P2_CHAINCODE = 1;
    private static final int MAX_BLOCK_SIZE = 255;

    public Trx(LedgerDevice device) {
        super(device);
    }

    public WalletAddress getWalletAddress(String bip32Path, boolean verify) throws LedgerException {
        byte[] convertedPath = BIP32Helper.splitPath(bip32Path);
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 2, verify ? 1 : 0, 1, convertedPath);
        response.checkSW();
        return SerializeHelper.readWalletAddress(response.getResponse());
    }

    public TrxConfiguration getConfiguration() throws LedgerException {
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 6, 0, 0);
        response.checkSW();
        return new TrxConfiguration(response.getResponse());
    }

    public ECDSADeviceSignature signTransaction(String bip32Path, byte[] rawTransaction) throws LedgerException {
        return this.signInfoTransaction(bip32Path, rawTransaction, null);
    }

    public ECDSADeviceSignature signInfoTransaction(String bip32Path, byte[] rawTransaction, Vector<byte[]> provisioningData) throws LedgerException {
        int p1;
        int blockSize;
        byte[] convertedPath = BIP32Helper.splitPath(bip32Path);
        ApduExchange.ApduResponse response = null;
        for (int offset = 0; offset != rawTransaction.length; offset += blockSize) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int maxBlockSize = offset == 0 ? 255 - convertedPath.length : 255;
            int n = blockSize = offset + maxBlockSize > rawTransaction.length ? rawTransaction.length - offset : maxBlockSize;
            if (offset == 0) {
                out.write(convertedPath, 0, convertedPath.length);
            }
            out.write(Arrays.copyOfRange(rawTransaction, offset, offset + blockSize), 0, blockSize);
            p1 = offset == 0 ? (offset + blockSize == rawTransaction.length && (provisioningData == null || provisioningData.size() == 0) ? 16 : 0) : (offset + blockSize == rawTransaction.length && (provisioningData == null || provisioningData.size() == 0) ? 144 : 128);
            response = ApduExchange.exchangeApdu(this.device, 224, 4, p1, 0, out.toByteArray());
            if (response.getSW() == 27392) {
                throw new CustomContractNotEnabledException();
            }
            response.checkSW();
        }
        if (provisioningData != null && provisioningData.size() != 0) {
            for (int i = 0; i < provisioningData.size(); ++i) {
                p1 = i != provisioningData.size() - 1 ? 160 + i : 0xA0 | 8 + provisioningData.size() - 1;
                response = ApduExchange.exchangeApdu(this.device, 224, 4, p1, 0, provisioningData.get(i));
                response.checkSW();
            }
        }
        byte[] responseData = response.getResponse();
        return new ECDSADeviceSignature(responseData[64] & 0xFF, Arrays.copyOfRange(responseData, 0, 32), Arrays.copyOfRange(responseData, 32, 64));
    }

    public ECDSADeviceSignature signPersonalMessage(String bip32Path, byte[] message) throws LedgerException {
        int blockSize;
        byte[] convertedPath = BIP32Helper.splitPath(bip32Path);
        ApduExchange.ApduResponse response = null;
        for (int offset = 0; offset != message.length; offset += blockSize) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int maxBlockSize = offset == 0 ? 255 - convertedPath.length - 4 : 255;
            int n = blockSize = offset + maxBlockSize > message.length ? message.length - offset : maxBlockSize;
            if (offset == 0) {
                out.write(convertedPath, 0, convertedPath.length);
                SerializeHelper.writeUint32BE(out, message.length);
            }
            out.write(Arrays.copyOfRange(message, offset, offset + blockSize), 0, blockSize);
            response = ApduExchange.exchangeApdu(this.device, 224, 8, offset == 0 ? 0 : 128, 0, out.toByteArray());
            response.checkSW();
        }
        byte[] responseData = response.getResponse();
        return new ECDSADeviceSignature(responseData[64] & 0xFF, Arrays.copyOfRange(responseData, 0, 32), Arrays.copyOfRange(responseData, 32, 64));
    }

    public byte[] getTrc10TokenInformation(Long id) {
        return TrxCache.lookupTrc10(id);
    }

    public byte[] getExchangeInformation(Long id) {
        return TrxCache.lookupExchange(id);
    }

    public class TrxConfiguration {
        public static final int FLAG_DATA_ALLOWED = 1;
        public static final int FLAG_CONTRACT_ALLOWED = 2;
        public static final int FLAG_TRUNCATE_ADDRESS = 4;
        private int flags;

        TrxConfiguration(byte[] response) {
            int offset = 0;
            this.flags = response[offset++] & 0xFF;
            if (response[offset] == 0 && response[offset + 1] == 1 && response[offset + 2] < 2) {
                this.flags |= 1;
                this.flags &= 0xFFFFFFFD;
            }
            if (response[offset] == 0 && response[offset + 1] == 1 && response[offset + 2] < 5) {
                this.flags &= 0xFFFFFFFB;
            }
        }

        public int getFlags() {
            return this.flags;
        }

        public String flagsToString() {
            String result = "";
            if ((this.flags & 1) != 0) {
                result = result + "Data signing allowed,";
            }
            if ((this.flags & 2) != 0) {
                result = result + "Custom contracts allowed,";
            }
            if ((this.flags & 4) != 0) {
                result = result + "Truncate address,";
            }
            if (result.length() == 0) {
                return result;
            }
            return result.substring(0, result.length() - 1);
        }

        public String toString() {
            return this.flagsToString();
        }
    }
}

