/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.apps;

import com.ledger.lib.LedgerException;
import com.ledger.lib.WrongApplicationException;
import com.ledger.lib.transport.LedgerDevice;
import com.ledger.lib.utils.ApduExchange;
import com.ledger.lib.utils.SerializeHelper;
import java.util.Arrays;

public class LedgerApplication {
    private static final int CLA_COMMON_SDK = 176;
    private static final int INS_GET_APP_NAME_AND_VERSION = 1;
    private static final int INS_GET_WALLET_ID = 4;
    private static final int INS_GET_WALLET_ID_NATIVE = 2;
    private static final int INS_EXIT = 167;
    private static final int NATIVE_WALLET_ID_FORMAT = 1;
    protected LedgerDevice device;

    public LedgerApplication(LedgerDevice device) {
        this.device = device;
    }

    public ApplicationDetails getApplicationDetails() throws LedgerException {
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 176, 1, 0, 0);
        response.checkSW();
        return new ApplicationDetails(response.getResponse());
    }

    public byte[] getWalletID() throws LedgerException {
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 176, 2, 0, 0);
        if (response.getSW() == 36864) {
            byte[] responseData = response.getResponse();
            if (responseData[0] != 1) {
                throw new LedgerException(LedgerException.ExceptionReason.INTERNAL_ERROR, "Unsupported Wallet ID format");
            }
            int idLength = responseData[1] & 0xFF;
            return Arrays.copyOfRange(responseData, 2, idLength + 2);
        }
        response = ApduExchange.exchangeApdu(this.device, 176, 4, 0, 0);
        if (response.getSW() == 36864) {
            byte[] responseData = response.getResponse();
            return Arrays.copyOfRange(responseData, 0, responseData.length - 2);
        }
        throw new WrongApplicationException();
    }

    public boolean exitApplication() throws LedgerException {
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 176, 167, 0, 0);
        return response.getSW() == 36864;
    }

    public class ApplicationDetails {
        private static final int APP_DETAILS_FORMAT_VERSION = 1;
        private String name;
        private String version;
        private int flags;

        ApplicationDetails(byte[] response) {
            int offset = 0;
            if (response[offset++] != 1) {
                throw new LedgerException(LedgerException.ExceptionReason.INTERNAL_ERROR, "Unsupported application format");
            }
            int nameLength = response[offset++] & 0xFF;
            this.name = SerializeHelper.readString(response, offset, nameLength);
            offset += nameLength;
            int versionLength = response[offset++] & 0xFF;
            this.version = SerializeHelper.readString(response, offset, versionLength);
            offset += versionLength;
            this.flags = response[offset++] & 0xFF;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public int getFlags() {
            return this.flags;
        }

        public String toString() {
            return this.name + " " + this.version + " " + Integer.toHexString(this.flags);
        }
    }
}

